/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.tdb.solver;

import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.sparql.ARQInternalErrorException;
import com.hp.hpl.jena.sparql.algebra.Op;
import com.hp.hpl.jena.sparql.algebra.op.OpBGP;
import com.hp.hpl.jena.sparql.algebra.op.OpDatasetNames;
import com.hp.hpl.jena.sparql.algebra.op.OpDistinct;
import com.hp.hpl.jena.sparql.algebra.op.OpFilter;
import com.hp.hpl.jena.sparql.algebra.op.OpQuadPattern;
import com.hp.hpl.jena.sparql.algebra.op.OpReduced;
import com.hp.hpl.jena.sparql.algebra.optimize.TransformFilterPlacement;
import com.hp.hpl.jena.sparql.core.BasicPattern;
import com.hp.hpl.jena.sparql.core.Quad;
import com.hp.hpl.jena.sparql.core.Substitute;
import com.hp.hpl.jena.sparql.engine.ExecutionContext;
import com.hp.hpl.jena.sparql.engine.QueryIterator;
import com.hp.hpl.jena.sparql.engine.iterator.QueryIterPeek;
import com.hp.hpl.jena.sparql.engine.main.OpExecutor;
import com.hp.hpl.jena.sparql.engine.main.OpExecutorFactory;
import com.hp.hpl.jena.sparql.engine.main.QC;
import com.hp.hpl.jena.sparql.engine.optimizer.reorder.ReorderProc;
import com.hp.hpl.jena.sparql.engine.optimizer.reorder.ReorderTransformation;
import com.hp.hpl.jena.sparql.expr.ExprList;
import com.hp.hpl.jena.sparql.mgt.Explain;
import com.hp.hpl.jena.tdb.solver.QC2;
import com.hp.hpl.jena.tdb.solver.SolverLib;
import com.hp.hpl.jena.tdb.store.DatasetGraphTDB;
import com.hp.hpl.jena.tdb.store.GraphNamedTDB;
import com.hp.hpl.jena.tdb.store.GraphTDB;
import com.hp.hpl.jena.tdb.store.GraphTriplesTDB;
import com.hp.hpl.jena.tdb.store.NodeId;
import org.openjena.atlas.iterator.Filter;
import org.openjena.atlas.lib.Tuple;
import org.openjena.atlas.logging.Log;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpExecutorTDB
extends OpExecutor {
    private static final Logger log = LoggerFactory.getLogger(OpExecutorTDB.class);
    public static final OpExecutorFactory OpExecFactoryTDB = new OpExecutorFactory(){

        public OpExecutor create(ExecutionContext execCxt) {
            return new OpExecutorTDB(execCxt);
        }
    };
    private final boolean isForTDB;
    private static OpExecutorFactory plainFactory = new OpExecutorPlainFactoryTDB();

    public OpExecutorTDB(ExecutionContext execCxt) {
        super(execCxt);
        this.isForTDB = execCxt.getActiveGraph() instanceof GraphTDB;
    }

    protected QueryIterator execute(OpDistinct opDistinct, QueryIterator input) {
        return super.execute(opDistinct, input);
    }

    protected QueryIterator execute(OpReduced opReduced, QueryIterator input) {
        return super.execute(opReduced, input);
    }

    protected QueryIterator execute(OpFilter opFilter, QueryIterator input) {
        if (!this.isForTDB) {
            return super.execute(opFilter, input);
        }
        if (OpBGP.isBGP(opFilter.getSubOp())) {
            GraphTDB graph = (GraphTDB)this.execCxt.getActiveGraph();
            OpBGP opBGP = (OpBGP)opFilter.getSubOp();
            return OpExecutorTDB.executeBGP(graph, opBGP, input, opFilter.getExprs(), this.execCxt);
        }
        if (opFilter.getSubOp() instanceof OpQuadPattern) {
            OpQuadPattern quadPattern = (OpQuadPattern)opFilter.getSubOp();
            DatasetGraphTDB ds = (DatasetGraphTDB)this.execCxt.getDataset();
            return OpExecutorTDB.optimizeExecuteQuads(ds, input, quadPattern.getGraphNode(), quadPattern.getBasicPattern(), opFilter.getExprs(), this.execCxt);
        }
        return super.execute(opFilter, input);
    }

    protected QueryIterator execute(OpBGP opBGP, QueryIterator input) {
        if (!this.isForTDB) {
            return super.execute(opBGP, input);
        }
        GraphTDB graph = (GraphTDB)this.execCxt.getActiveGraph();
        return OpExecutorTDB.executeBGP(graph, opBGP, input, null, this.execCxt);
    }

    protected QueryIterator execute(OpQuadPattern quadPattern, QueryIterator input) {
        if (!this.isForTDB) {
            return super.execute(quadPattern, input);
        }
        DatasetGraphTDB ds = (DatasetGraphTDB)this.execCxt.getDataset();
        BasicPattern bgp = quadPattern.getBasicPattern();
        Node gn = quadPattern.getGraphNode();
        return OpExecutorTDB.optimizeExecuteQuads(ds, input, gn, bgp, null, this.execCxt);
    }

    private static QueryIterator executeBGP(GraphTDB graph, OpBGP opBGP, QueryIterator input, ExprList exprs, ExecutionContext execCxt) {
        if (!OpExecutorTDB.isDefaultGraphStorage(graph.getGraphNode())) {
            DatasetGraphTDB ds = graph.getDataset();
            return OpExecutorTDB.optimizeExecuteQuads(ds, input, graph.getGraphNode(), opBGP.getPattern(), exprs, execCxt);
        }
        return OpExecutorTDB.optimizeExecuteTriples(graph, input, opBGP.getPattern(), exprs, execCxt);
    }

    private static QueryIterator optimizeExecuteTriples(GraphTDB graph, QueryIterator input, BasicPattern pattern, ExprList exprs, ExecutionContext execCxt) {
        if (!input.hasNext()) {
            return input;
        }
        ReorderTransformation transform = graph.getReorderTransform();
        if (transform != null) {
            QueryIterPeek peek = QueryIterPeek.create(input, execCxt);
            input = peek;
            pattern = OpExecutorTDB.reorder(pattern, peek, transform);
        }
        Op op = null;
        op = exprs != null ? TransformFilterPlacement.transform(exprs, pattern) : new OpBGP(pattern);
        return OpExecutorTDB.plainExecute(op, input, execCxt);
    }

    private static QueryIterator optimizeExecuteQuads(DatasetGraphTDB ds, QueryIterator input, Node gn, BasicPattern bgp, ExprList exprs, ExecutionContext execCxt) {
        if (!input.hasNext()) {
            return input;
        }
        if ((gn = OpExecutorTDB.decideGraphNode(gn, execCxt)) == null) {
            return OpExecutorTDB.optimizeExecuteTriples(ds.getEffectiveDefaultGraph(), input, bgp, exprs, execCxt);
        }
        ReorderTransformation transform = ds.getTransform();
        if (transform != null) {
            QueryIterPeek peek = QueryIterPeek.create(input, execCxt);
            input = peek;
            bgp = OpExecutorTDB.reorder(bgp, peek, transform);
        }
        Op op = null;
        op = exprs != null ? TransformFilterPlacement.transform(exprs, gn, bgp) : new OpQuadPattern(gn, bgp);
        return OpExecutorTDB.plainExecute(op, input, execCxt);
    }

    private static QueryIterator plainExecute(Op op, QueryIterator input, ExecutionContext execCxt) {
        ExecutionContext ec2 = new ExecutionContext(execCxt);
        ec2.setExecutor(plainFactory);
        return QC.execute(op, input, ec2);
    }

    private static BasicPattern reorder(BasicPattern pattern, QueryIterPeek peek, ReorderTransformation transform) {
        if (transform != null) {
            if (!peek.hasNext()) {
                throw new ARQInternalErrorException("Peek iterator is already empty");
            }
            BasicPattern pattern2 = Substitute.substitute(pattern, peek.peek());
            ReorderProc proc = transform.reorderIndexes(pattern2);
            pattern = proc.reorder(pattern);
        }
        return pattern;
    }

    public static Node decideGraphNode(Node gn, ExecutionContext execCxt) {
        if (OpExecutorTDB.isDefaultGraphStorage(gn)) {
            return null;
        }
        boolean doingUnion = false;
        if (gn.equals(Quad.unionGraph)) {
            doingUnion = true;
        }
        if (doingUnion) {
            gn = Node.ANY;
        }
        return gn;
    }

    private static boolean isDefaultGraphStorage(Node gn) {
        if (gn == null) {
            return true;
        }
        return Quad.isDefaultGraph(gn);
    }

    protected QueryIterator execute(OpDatasetNames dsNames, QueryIterator input) {
        DatasetGraphTDB ds = (DatasetGraphTDB)this.execCxt.getDataset();
        Filter<Tuple<NodeId>> filter = QC2.getFilter(this.execCxt.getContext());
        return SolverLib.graphNames(ds, dsNames.getGraphNode(), input, filter, this.execCxt);
    }

    private static class OpExecutorPlainTDB
    extends OpExecutor {
        Filter<Tuple<NodeId>> filter = null;

        public OpExecutorPlainTDB(ExecutionContext execCxt) {
            super(execCxt);
            this.filter = QC2.getFilter(execCxt.getContext());
        }

        public QueryIterator execute(OpBGP opBGP, QueryIterator input) {
            Graph g = this.execCxt.getActiveGraph();
            if (g instanceof GraphTDB) {
                BasicPattern bgp = opBGP.getPattern();
                Explain.explain("Execute", bgp, this.execCxt.getContext());
                return SolverLib.execute((GraphTDB)g, bgp, input, this.filter, this.execCxt);
            }
            Log.warn(this, "Non-GraphTDB passed to OpExecutorPlainTDB");
            return super.execute(opBGP, input);
        }

        public QueryIterator execute(OpQuadPattern opQuadPattern, QueryIterator input) {
            Node gn = opQuadPattern.getGraphNode();
            gn = OpExecutorTDB.decideGraphNode(gn, this.execCxt);
            if (this.execCxt.getDataset() instanceof DatasetGraphTDB) {
                DatasetGraphTDB ds = (DatasetGraphTDB)this.execCxt.getDataset();
                Explain.explain("Execute", opQuadPattern.getPattern(), this.execCxt.getContext());
                BasicPattern bgp = opQuadPattern.getBasicPattern();
                return SolverLib.execute(ds, gn, bgp, input, this.filter, this.execCxt);
            }
            Graph g = this.execCxt.getActiveGraph();
            if (g instanceof GraphTDB) {
                if (g instanceof GraphTriplesTDB) {
                    BasicPattern bgp = opQuadPattern.getBasicPattern();
                    Explain.explain("Execute", bgp, this.execCxt.getContext());
                    return SolverLib.execute((GraphTDB)g, bgp, input, this.filter, this.execCxt);
                }
                if (g instanceof GraphNamedTDB) {
                    Explain.explain("Execute", opQuadPattern.getPattern(), this.execCxt.getContext());
                    return SolverLib.execute(((GraphTDB)g).getDataset(), opQuadPattern.getGraphNode(), opQuadPattern.getBasicPattern(), input, this.filter, this.execCxt);
                }
            }
            Log.warn(this, "Non-DatasetGraphTDB passed to OpExecutorPlainTDB");
            return super.execute(opQuadPattern, input);
        }
    }

    private static class OpExecutorPlainFactoryTDB
    implements OpExecutorFactory {
        private OpExecutorPlainFactoryTDB() {
        }

        public OpExecutor create(ExecutionContext execCxt) {
            return new OpExecutorPlainTDB(execCxt);
        }
    }
}

