/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.tdb.solver;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.sparql.core.Var;
import com.hp.hpl.jena.sparql.engine.binding.BindingBase;
import com.hp.hpl.jena.tdb.lib.NodeFmtLib;
import com.hp.hpl.jena.tdb.nodetable.NodeTable;
import com.hp.hpl.jena.tdb.solver.BindingNodeId;
import com.hp.hpl.jena.tdb.store.NodeId;
import java.util.Iterator;
import java.util.Map;
import org.openjena.atlas.logging.Log;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BindingTDB
extends BindingBase {
    private final NodeTable nodeTable;
    private final BindingNodeId idBinding;
    private static final boolean caching = false;
    private final Map<Var, Node> cache = null;

    public BindingTDB(BindingNodeId idBinding, NodeTable nodeTable) {
        super(idBinding.getParentBinding());
        this.idBinding = idBinding;
        this.nodeTable = nodeTable;
    }

    @Override
    protected void add1(Var var, Node node) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected int size1() {
        return this.idBinding.size();
    }

    @Override
    protected Iterator<Var> vars1() {
        return this.idBinding.iterator();
    }

    @Override
    protected boolean isEmpty1() {
        return this.size1() == 0;
    }

    @Override
    public boolean contains1(Var var) {
        return this.idBinding.containsKey(var);
    }

    public BindingNodeId getBindingId() {
        return this.idBinding;
    }

    public NodeId getNodeId(Var var) {
        NodeId id = (NodeId)this.idBinding.get(var);
        if (id != null) {
            return id;
        }
        if (this.parent == null) {
            return null;
        }
        if (this.parent instanceof BindingTDB) {
            return ((BindingTDB)this.parent).getNodeId(var);
        }
        return null;
    }

    @Override
    public Node get1(Var var) {
        try {
            Node n = this.cacheGet(var);
            if (n != null) {
                return n;
            }
            NodeId id = (NodeId)this.idBinding.get(var);
            if (id == null) {
                return null;
            }
            n = this.nodeTable.getNodeForNodeId(id);
            this.cachePut(var, n);
            return n;
        }
        catch (Exception ex) {
            Log.fatal(this, String.format("get1(%s)", var), (Throwable)ex);
            return null;
        }
    }

    private void cachePut(Var var, Node n) {
        if (this.cache != null) {
            this.cache.put(var, n);
        }
    }

    private Node cacheGet(Var var) {
        if (this.cache == null) {
            return null;
        }
        return this.cache.get(var);
    }

    @Override
    protected void checkAdd1(Var var, Node node) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected void format(StringBuffer sbuff, Var var) {
        NodeId id = (NodeId)this.idBinding.get(var);
        String extra = "";
        if (id != null) {
            extra = "/" + id;
        }
        Node node = this.get(var);
        String tmp = NodeFmtLib.displayStr(node);
        sbuff.append("( ?" + var.getVarName() + extra + " = " + tmp + " )");
    }
}

