/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.tdb.nodetable;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.tdb.index.TupleTable;
import com.hp.hpl.jena.tdb.nodetable.NodeTupleTable;
import com.hp.hpl.jena.tdb.nodetable.NodeTupleTableWrapper;
import com.hp.hpl.jena.tdb.store.NodeId;
import java.util.Iterator;
import org.openjena.atlas.lib.ArrayUtils;
import org.openjena.atlas.lib.Tuple;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NodeTupleTableView
extends NodeTupleTableWrapper {
    private Node prefix;
    private NodeId prefixId;

    public NodeTupleTableView(NodeTupleTable ntt, Node prefix) {
        super(ntt);
        this.prefix = prefix;
        this.prefixId = ntt.getNodeTable().getNodeIdForNode(prefix);
    }

    @Override
    public boolean addRow(Node ... nodes) {
        nodes = NodeTupleTableView.push(Node.class, this.prefix, nodes);
        return super.addRow(nodes);
    }

    @Override
    public boolean deleteRow(Node ... nodes) {
        nodes = NodeTupleTableView.push(Node.class, this.prefix, nodes);
        return super.deleteRow(nodes);
    }

    @Override
    public Iterator<Tuple<Node>> find(Node ... nodes) {
        nodes = NodeTupleTableView.push(Node.class, this.prefix, nodes);
        return super.find(nodes);
    }

    private static <T> T[] push(Class<T> cls, T x, T[] array) {
        T[] array2 = ArrayUtils.alloc(cls, array.length + 1);
        System.arraycopy(array, 0, array2, 1, array.length);
        array2[0] = x;
        return array2;
    }

    @Override
    public Iterator<Tuple<NodeId>> find(NodeId ... ids) {
        ids = NodeTupleTableView.push(NodeId.class, this.prefixId, ids);
        return super.find(ids);
    }

    @Override
    public Iterator<Tuple<NodeId>> findAsNodeIds(Node ... nodes) {
        nodes = NodeTupleTableView.push(Node.class, this.prefix, nodes);
        return super.findAsNodeIds(nodes);
    }

    @Override
    public TupleTable getTupleTable() {
        return super.getTupleTable();
    }
}

