/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.tdb.nodetable;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.tdb.nodetable.NodeTable;
import com.hp.hpl.jena.tdb.store.NodeId;
import java.util.Iterator;
import org.openjena.atlas.lib.Cache;
import org.openjena.atlas.lib.CacheFactory;
import org.openjena.atlas.lib.CacheSet;
import org.openjena.atlas.lib.Pair;
import org.openjena.atlas.logging.Log;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NodeTableCache
implements NodeTable {
    private Cache<Node, NodeId> node2id_Cache = null;
    private Cache<NodeId, Node> id2node_Cache = null;
    private CacheSet<Node> notPresent;
    private NodeTable baseTable;

    public static NodeTable create(NodeTable nodeTable, int nodeToIdCacheSize, int idToNodeCacheSize) {
        if (nodeToIdCacheSize <= 0 && idToNodeCacheSize <= 0) {
            return nodeTable;
        }
        return new NodeTableCache(nodeTable, nodeToIdCacheSize, idToNodeCacheSize);
    }

    private NodeTableCache(NodeTable baseTable, int nodeToIdCacheSize, int idToNodeCacheSize) {
        this.baseTable = baseTable;
        if (nodeToIdCacheSize > 0) {
            this.node2id_Cache = CacheFactory.createCache(nodeToIdCacheSize);
        }
        if (idToNodeCacheSize > 0) {
            this.id2node_Cache = CacheFactory.createCache(idToNodeCacheSize);
        }
        this.notPresent = CacheFactory.createCacheSet(100);
    }

    @Override
    public Node getNodeForNodeId(NodeId id) {
        return this._retrieveNodeByNodeId(id);
    }

    @Override
    public NodeId getNodeIdForNode(Node node) {
        return this._idForNode(node, false);
    }

    @Override
    public NodeId getAllocateNodeId(Node node) {
        return this._idForNode(node, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Node _retrieveNodeByNodeId(NodeId id) {
        if (NodeId.doesNotExist(id)) {
            return null;
        }
        if (NodeId.isAny(id)) {
            return null;
        }
        NodeTableCache nodeTableCache = this;
        synchronized (nodeTableCache) {
            Node n = this.cacheLookup(id);
            if (n != null) {
                return n;
            }
            if (this.baseTable == null) {
                System.err.println("" + this);
            }
            n = this.baseTable.getNodeForNodeId(id);
            this.cacheUpdate(n, id);
            return n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private NodeId _idForNode(Node node, boolean allocate) {
        if (node == Node.ANY) {
            return NodeId.NodeIdAny;
        }
        NodeTableCache nodeTableCache = this;
        synchronized (nodeTableCache) {
            NodeId nodeId = this.cacheLookup(node);
            if (nodeId != null) {
                return nodeId;
            }
            nodeId = allocate ? this.baseTable.getAllocateNodeId(node) : this.baseTable.getNodeIdForNode(node);
            this.cacheUpdate(node, nodeId);
            return nodeId;
        }
    }

    private Node cacheLookup(NodeId id) {
        if (this.id2node_Cache == null) {
            return null;
        }
        return this.id2node_Cache.get(id);
    }

    private NodeId cacheLookup(Node node) {
        if (this.notPresent.contains(node)) {
            return null;
        }
        if (this.node2id_Cache == null) {
            return null;
        }
        return this.node2id_Cache.get(node);
    }

    private void cacheUpdate(Node node, NodeId id) {
        if (NodeId.doesNotExist(id)) {
            this.notPresent.add(node);
            return;
        }
        if (id == NodeId.NodeIdAny) {
            Log.warn(this, "Attempt to cache NodeIdAny - ignored");
            return;
        }
        if (this.node2id_Cache != null) {
            this.node2id_Cache.put(node, id);
        }
        if (this.id2node_Cache != null) {
            this.id2node_Cache.put(id, node);
        }
        if (this.notPresent.contains(node)) {
            this.notPresent.remove(node);
        }
    }

    @Override
    public synchronized void close() {
        if (this.baseTable == null) {
            return;
        }
        this.baseTable.close();
        this.node2id_Cache = null;
        this.id2node_Cache = null;
        this.notPresent = null;
        this.baseTable = null;
    }

    @Override
    public void sync() {
        this.sync(true);
    }

    @Override
    public synchronized void sync(boolean force) {
        this.baseTable.sync(force);
    }

    @Override
    public Iterator<Pair<NodeId, Node>> all() {
        return this.baseTable.all();
    }
}

