/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.tdb.index.factories;

import com.hp.hpl.jena.tdb.base.block.BlockMgr;
import com.hp.hpl.jena.tdb.base.file.FileSet;
import com.hp.hpl.jena.tdb.base.record.RecordFactory;
import com.hp.hpl.jena.tdb.index.Index;
import com.hp.hpl.jena.tdb.index.IndexFactory;
import com.hp.hpl.jena.tdb.index.IndexRangeFactory;
import com.hp.hpl.jena.tdb.index.RangeIndex;
import com.hp.hpl.jena.tdb.index.btree.BTree;
import com.hp.hpl.jena.tdb.index.btree.BTreeParams;
import com.hp.hpl.jena.tdb.index.factories.IndexFactoryBPlusTree;

public class IndexFactoryBTree
implements IndexFactory,
IndexRangeFactory {
    private final int blockSize;

    public IndexFactoryBTree() {
        this(8192);
    }

    public IndexFactoryBTree(int blockSize) {
        this.blockSize = blockSize;
    }

    public Index createIndex(FileSet fileset, RecordFactory recordFactory) {
        return this.createRangeIndex(fileset, recordFactory);
    }

    public RangeIndex createRangeIndex(FileSet fileset, RecordFactory recordFactory) {
        int order = BTreeParams.calcOrder(this.blockSize, recordFactory);
        BTreeParams params = new BTreeParams(order, recordFactory);
        String fn = fileset.filename("idx");
        BlockMgr blockMgr = IndexFactoryBPlusTree.createBlockMgr(fileset, "idx", this.blockSize);
        BTree bTree = new BTree(params, blockMgr);
        return bTree;
    }
}

