/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.tdb.index.ext;

import com.hp.hpl.jena.tdb.base.block.BlockConverter;
import com.hp.hpl.jena.tdb.base.block.BlockMgr;
import com.hp.hpl.jena.tdb.base.block.BlockType;
import com.hp.hpl.jena.tdb.base.record.RecordException;
import com.hp.hpl.jena.tdb.base.record.RecordFactory;
import com.hp.hpl.jena.tdb.index.ext.HashBucket;
import java.nio.ByteBuffer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HashBucketMgr
extends BlockConverter<HashBucket> {
    public HashBucketMgr(RecordFactory factory, BlockMgr blockMgr) {
        super(null, blockMgr);
        Block2HashBucketMgr conv = new Block2HashBucketMgr(factory, null);
        super.setConverter(conv);
    }

    public HashBucket create(int id, int hash, int hashBitLen) {
        HashBucket bucket = (HashBucket)super.create(id, BlockType.RECORD_BLOCK);
        bucket.setId(id);
        bucket.setTrieValue(hash);
        bucket.setTrieLength(hashBitLen);
        return bucket;
    }

    @Override
    public HashBucket get(int id) {
        HashBucket bucket = (HashBucket)super.get(id);
        bucket.setPageMgr(this);
        return bucket;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Block2HashBucketMgr
    implements BlockConverter.Converter<HashBucket> {
        private RecordFactory factory;
        private HashBucketMgr pageMgr;

        Block2HashBucketMgr(RecordFactory factory, HashBucketMgr pageMgr) {
            this.factory = factory;
            this.pageMgr = pageMgr;
        }

        @Override
        public HashBucket createFromByteBuffer(ByteBuffer bb, BlockType blkType) {
            if (blkType != BlockType.RECORD_BLOCK) {
                throw new RecordException("Not RECORD_BLOCK: " + blkType);
            }
            HashBucket bucket = new HashBucket(-1, -1, -1, bb, this.factory, this.pageMgr, 0);
            return bucket;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public HashBucket fromByteBuffer(ByteBuffer byteBuffer) {
            ByteBuffer byteBuffer2 = byteBuffer;
            synchronized (byteBuffer2) {
                int count = byteBuffer.getInt(0);
                int hash = byteBuffer.getInt(4);
                int hashLen = byteBuffer.getInt(8);
                HashBucket bucket = new HashBucket(-1, hash, hashLen, byteBuffer, this.factory, this.pageMgr, count);
                return bucket;
            }
        }

        @Override
        public ByteBuffer toByteBuffer(HashBucket bucket) {
            int count = bucket.getRecordBuffer().size();
            bucket.setCount(count);
            bucket.getBackingByteBuffer().putInt(0, bucket.getCount());
            bucket.getBackingByteBuffer().putInt(4, bucket.getTrieValue());
            bucket.getBackingByteBuffer().putInt(8, bucket.getTrieBitLen());
            return bucket.getBackingByteBuffer();
        }
    }
}

