/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.tdb.index.btree;

import com.hp.hpl.jena.tdb.base.block.BlockConverter;
import com.hp.hpl.jena.tdb.base.block.BlockMgr;
import com.hp.hpl.jena.tdb.base.block.BlockType;
import com.hp.hpl.jena.tdb.base.buffer.PtrBuffer;
import com.hp.hpl.jena.tdb.base.buffer.RecordBuffer;
import com.hp.hpl.jena.tdb.index.btree.BTree;
import com.hp.hpl.jena.tdb.index.btree.BTreeException;
import com.hp.hpl.jena.tdb.index.btree.BTreeNode;
import com.hp.hpl.jena.tdb.index.btree.BTreeParams;
import com.hp.hpl.jena.tdb.sys.Session;
import java.nio.ByteBuffer;

final class BTreePageMgr
implements Session {
    private BTree btree;
    private BlockMgr blockMgr;
    private Block2BTreeNode converter;

    BTreePageMgr(BTree btree, BlockMgr blockMgr) {
        this.btree = btree;
        this.blockMgr = blockMgr;
        this.converter = new Block2BTreeNode();
    }

    public BlockMgr getBlockMgr() {
        return this.blockMgr;
    }

    public BTreeNode createRoot() {
        return this.create(-2, true);
    }

    public BTreeNode create(int parent, boolean makeLeaf) {
        int id = this.blockMgr.allocateId();
        ByteBuffer bb = this.blockMgr.allocateBuffer(id);
        BlockType bType = makeLeaf ? BlockType.RECORD_BLOCK : BlockType.BTREE_NODE;
        BTreeNode n = this.converter.createFromByteBuffer(bb, bType);
        n.id = id;
        n.parent = parent;
        return n;
    }

    public BTreeNode getRoot(int id) {
        return this.get(id, -2);
    }

    public BTreeNode get(int id, int parent) {
        ByteBuffer bb = this.blockMgr.get(id);
        BTreeNode n = this.converter.fromByteBuffer(bb);
        n.id = id;
        n.parent = parent;
        return n;
    }

    public void put(BTreeNode node) {
        ByteBuffer bb = this.converter.toByteBuffer(node);
        this.blockMgr.put(node.getId(), bb);
    }

    public void release(int id) {
        this.blockMgr.freeBlock(id);
    }

    public boolean valid(int id) {
        return this.blockMgr.valid(id);
    }

    public void dump() {
        int idx = 0;
        while (this.valid(idx)) {
            BTreeNode n = this.get(idx, -99);
            System.out.println(n);
            ++idx;
        }
    }

    public void startUpdate() {
        this.blockMgr.startUpdate();
    }

    public void finishUpdate() {
        this.blockMgr.finishUpdate();
    }

    public void startRead() {
        this.blockMgr.startRead();
    }

    public void finishRead() {
        this.blockMgr.finishRead();
    }

    private static final BlockType getType(int x) {
        return BlockType.extract(x >>> 24);
    }

    private static final int encCount(BlockType type, int i) {
        return type.id() << 24 | i & 0xFFFFFF;
    }

    private static final int decCount(int i) {
        return i & 0xFFFFFF;
    }

    private static BTreeNode overlay(BTree bTree, ByteBuffer byteBuffer, boolean asLeaf, int count) {
        BTreeNode n = new BTreeNode(bTree, -1, byteBuffer);
        BTreePageMgr.formatBTreeNode(n, bTree, byteBuffer, asLeaf, count);
        return n;
    }

    static BTreeNode formatBTreeNode(BTreeNode n, BTree bTree, ByteBuffer byteBuffer, boolean leaf, int count) {
        int header;
        int recBuffLen;
        int ptrBuffLen;
        BTreeParams params = bTree.getParams();
        if (leaf) {
            ptrBuffLen = params.MaxPtr * BTreeParams.getPtrLength();
            recBuffLen = params.MaxRecLeaf * params.getRecordLength();
        } else {
            ptrBuffLen = params.MaxPtr * BTreeParams.getPtrLength();
            recBuffLen = params.MaxRecNonLeaf * params.getRecordLength();
        }
        n.id = -1;
        n.parent = -2;
        n.count = count;
        n.isLeaf = leaf;
        int rStart = header = BTreeParams.BlockHeaderSize;
        int pStart = header + recBuffLen;
        int numPtrs = -1;
        if (n.count < 0) {
            numPtrs = 0;
            n.count = BTreePageMgr.decCount(n.count);
        } else {
            numPtrs = n.count == 0 ? 0 : n.count + 1;
        }
        n.byteBuffer.position(rStart);
        n.byteBuffer.limit(rStart + recBuffLen);
        ByteBuffer bbr = n.byteBuffer.slice();
        n.records = new RecordBuffer(bbr, n.bTreeParams.recordFactory, n.count);
        n.byteBuffer.position(pStart);
        n.byteBuffer.limit(pStart + ptrBuffLen);
        ByteBuffer bbi = n.byteBuffer.slice();
        n.ptrs = new PtrBuffer(bbi, numPtrs);
        n.byteBuffer.rewind();
        return n;
    }

    static final void formatForRoot(BTreeNode n, boolean asLeaf) {
        BTreePageMgr.formatBTreeNode(n, n.bTree, n.getByteBuffer(), asLeaf, 0);
        n.id = 0;
        n.parent = -2;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Block2BTreeNode
    implements BlockConverter.Converter<BTreeNode> {
        private Block2BTreeNode() {
        }

        @Override
        public BTreeNode createFromByteBuffer(ByteBuffer bb, BlockType bType) {
            return BTreePageMgr.overlay(BTreePageMgr.this.btree, bb, bType == BlockType.RECORD_BLOCK, 0);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public BTreeNode fromByteBuffer(ByteBuffer byteBuffer) {
            ByteBuffer byteBuffer2 = byteBuffer;
            synchronized (byteBuffer2) {
                int x = byteBuffer.getInt(0);
                BlockType type = BTreePageMgr.getType(x);
                if (type != BlockType.BTREE_NODE && type != BlockType.RECORD_BLOCK) {
                    throw new BTreeException("Wrong block type: " + type);
                }
                int count = BTreePageMgr.decCount(x);
                return BTreePageMgr.overlay(BTreePageMgr.this.btree, byteBuffer, type == BlockType.RECORD_BLOCK, count);
            }
        }

        @Override
        public ByteBuffer toByteBuffer(BTreeNode node) {
            ByteBuffer bb = node.getByteBuffer();
            BlockType bType = node.isLeaf ? BlockType.RECORD_BLOCK : BlockType.BTREE_NODE;
            int c = BTreePageMgr.encCount(bType, node.count);
            bb.putInt(0, c);
            return bb;
        }
    }
}

