/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.tdb.index.bplustree;

import com.hp.hpl.jena.tdb.base.block.BlockMgr;
import com.hp.hpl.jena.tdb.base.block.BlockMgrFactory;
import com.hp.hpl.jena.tdb.base.buffer.RecordBuffer;
import com.hp.hpl.jena.tdb.base.record.RecordFactory;
import com.hp.hpl.jena.tdb.base.recordfile.RecordBufferPage;
import com.hp.hpl.jena.tdb.base.recordfile.RecordBufferPageMgr;
import com.hp.hpl.jena.tdb.index.bplustree.BPTreeNode;
import com.hp.hpl.jena.tdb.index.bplustree.BPTreeNodeMgr;
import com.hp.hpl.jena.tdb.index.bplustree.BPlusTree;
import com.hp.hpl.jena.tdb.sys.SystemTDB;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import org.openjena.atlas.lib.ByteBufferLib;

class BPlusTreeToolsx {
    BPlusTreeToolsx() {
    }

    public static void binDump(String filename) {
        try {
            int x;
            RandomAccessFile fh = new RandomAccessFile(filename, "r");
            ByteBuffer bb = ByteBuffer.allocate(8192);
            FileChannel ch = fh.getChannel();
            boolean idx = false;
            while ((x = ch.read(bb)) >= 0) {
                ByteBufferLib.print(bb);
                bb.clear();
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public static void bpt_scan_record_buffer(String filename, boolean verbose) {
        BlockMgr blkMgr = BlockMgrFactory.createStdFileNoCache(filename, 8192);
        BPlusTreeToolsx.bpt_scan_record_buffer(blkMgr, verbose);
        blkMgr.close();
    }

    public static void bpt_scan_record_buffer(BPlusTree bpt, boolean verbose) {
        BPlusTreeToolsx.bpt_scan_record_buffer(bpt.getRecordsMgr().getBlockMgr(), verbose);
    }

    public static void bpt_scan_record_buffer(BlockMgr blkMgr, boolean verbose) {
        RecordFactory f = SystemTDB.indexRecordTripleFactory;
        RecordBufferPageMgr recordPageMgr = new RecordBufferPageMgr(f, blkMgr);
        BPlusTreeToolsx.bpt_scan_record_buffer(recordPageMgr, verbose);
    }

    public static void bpt_scan_record_buffer(RecordBufferPageMgr recordPageMgr, boolean verbose) {
        System.out.print("[Scan Records] start\n");
        int idx = 0;
        int n = 0;
        int total = 0;
        if (verbose) {
            System.out.printf("recordPageMgr = %s\n", recordPageMgr);
        }
        try {
            while (idx >= 0) {
                if (verbose) {
                    System.out.printf("idx = %d\n", idx);
                }
                RecordBufferPage page = recordPageMgr.get(idx);
                if (verbose) {
                    System.out.printf("%04d :: id=%04d -> link=%04d [count=%d, max=%d]\n", n, page.getId(), page.getLink(), page.getCount(), page.getMaxSize());
                }
                RecordBuffer rb = page.getRecordBuffer();
                if (verbose) {
                    System.out.printf("     :: %d %d\n", rb.getSize(), rb.maxSize());
                }
                total += rb.size();
                idx = page.getLink();
                ++n;
            }
        }
        catch (Exception ex) {
            System.out.println("Exception: " + ex);
        }
        System.out.printf("[Scan Records] Count = %d in %d blocks (avg: %.2f)\n", total, n, Float.valueOf((float)total / (float)n));
    }

    public static void bpt_scan_nodes(BPlusTree bpt, boolean verbose) {
        System.out.print("[Scan Nodes] start\n");
        RecordFactory f = SystemTDB.indexRecordTripleFactory;
        BPTreeNodeMgr nodeMgr = new BPTreeNodeMgr(bpt, bpt.getNodeManager().getBlockMgr());
        int idx = 0;
        int n = 0;
        int total = 0;
        if (verbose) {
            System.out.printf("BPTreeNodeMgr = %s\n", nodeMgr);
        }
        try {
            while (idx >= 0) {
                BPTreeNode node;
                if (verbose) {
                    System.out.printf("idx = %d\n", idx);
                }
                if ((node = nodeMgr.get(idx, 0)) != null) {
                    System.out.println(node);
                    ++n;
                    ++idx;
                    continue;
                }
                break;
            }
        }
        catch (Exception ex) {
            System.out.println("Exception: " + ex);
            ex.printStackTrace();
        }
        System.out.printf("[Scan Nodes] Count = %d in %d blocks (avg: %.2f)\n", total, n, Float.valueOf((float)total / (float)n));
    }
}

