/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.tdb.index.bplustree;

import com.hp.hpl.jena.tdb.base.record.Record;
import com.hp.hpl.jena.tdb.base.recordfile.RecordBufferPage;
import com.hp.hpl.jena.tdb.base.recordfile.RecordBufferPageMgr;
import com.hp.hpl.jena.tdb.index.bplustree.BPTreeNode;
import com.hp.hpl.jena.tdb.index.bplustree.BPTreeNodeMgr;
import java.util.Iterator;
import java.util.List;
import org.openjena.atlas.iterator.Iter;
import org.openjena.atlas.lib.Pair;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class BPlusTreeRewriterUtils {
    static String divider = "----------------------------------------";
    static String nextDivider = null;

    BPlusTreeRewriterUtils() {
    }

    static Iterator<Pair<Integer, Record>> summarizeDataBlocks(Iterator<Pair<Integer, Record>> iter, RecordBufferPageMgr recordPageMgr) {
        BPlusTreeRewriterUtils.divider();
        List<Pair<Integer, Record>> x = Iter.toList(iter);
        for (Pair<Integer, Record> pair : x) {
            RecordBufferPage rbp = recordPageMgr.get(pair.car());
            System.out.printf("%s -- RecordBufferPage[id=%d,link=%d] (%d) -> [%s]\n", pair, rbp.getId(), rbp.getLink(), rbp.getCount(), rbp.getRecordBuffer().getHigh());
        }
        return x.iterator();
    }

    static Iterator<Pair<Integer, Record>> summarizeIndexBlocks(Iterator<Pair<Integer, Record>> iter2, BPTreeNodeMgr bptNodeMgr) {
        BPlusTreeRewriterUtils.divider();
        List<Pair<Integer, Record>> x = Iter.toList(iter2);
        for (Pair<Integer, Record> pair : x) {
            BPTreeNode bpNode = bptNodeMgr.get(pair.car(), -2);
            String hr = "null";
            if (!bpNode.getRecordBuffer().isEmpty()) {
                hr = bpNode.getRecordBuffer().getHigh().toString();
            }
            System.out.printf("%s -- BPTreeNode: %d (%d) -> [%s]\n", pair, bpNode.getId(), bpNode.getCount(), hr);
        }
        return x.iterator();
    }

    private static Iterator<Pair<Integer, Record>> printDataBlocks(Iterator<Pair<Integer, Record>> iter, RecordBufferPageMgr recordPageMgr) {
        BPlusTreeRewriterUtils.divider();
        List<Pair<Integer, Record>> x = Iter.toList(iter);
        System.out.printf(">>Packed data blocks\n", new Object[0]);
        for (Pair<Integer, Record> pair : x) {
            System.out.printf("  %s\n", pair);
            RecordBufferPage rbp = recordPageMgr.get(pair.car());
            System.out.println(rbp);
        }
        System.out.printf("<<Packed data blocks\n", new Object[0]);
        System.out.printf("Blocks: %d\n", x.size());
        return x.iterator();
    }

    static Iterator<Pair<Integer, Record>> printIndexBlocks(Iterator<Pair<Integer, Record>> iter2, BPTreeNodeMgr bptNodeMgr) {
        BPlusTreeRewriterUtils.divider();
        List<Pair<Integer, Record>> x = Iter.toList(iter2);
        System.out.printf(">>Packed index blocks\n", new Object[0]);
        for (Pair<Integer, Record> pair : x) {
            System.out.printf("  %s\n", pair);
            BPTreeNode bpNode = bptNodeMgr.get(pair.car(), -2);
            bpNode.setIsLeaf(true);
            System.out.printf("BPTreeNode: %d\n", bpNode.getId());
            System.out.println(bpNode);
        }
        System.out.printf("<<Packed index blocks\n", new Object[0]);
        return x.iterator();
    }

    static void divider() {
        if (nextDivider != null) {
            System.out.println(nextDivider);
        }
        nextDivider = divider;
    }
}

