/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.tdb.index;

import com.hp.hpl.jena.tdb.TDBException;
import com.hp.hpl.jena.tdb.base.record.Record;
import com.hp.hpl.jena.tdb.base.record.RecordFactory;
import com.hp.hpl.jena.tdb.index.RangeIndex;
import com.hp.hpl.jena.tdb.index.TupleIndexBase;
import com.hp.hpl.jena.tdb.lib.TupleLib;
import com.hp.hpl.jena.tdb.store.NodeId;
import java.util.Iterator;
import org.openjena.atlas.iterator.Filter;
import org.openjena.atlas.iterator.Iter;
import org.openjena.atlas.iterator.NullIterator;
import org.openjena.atlas.iterator.SingletonIterator;
import org.openjena.atlas.iterator.Transform;
import org.openjena.atlas.lib.Bytes;
import org.openjena.atlas.lib.ColumnMap;
import org.openjena.atlas.lib.Tuple;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TupleIndexRecord
extends TupleIndexBase {
    private static final boolean Check = false;
    private RangeIndex index;
    private RecordFactory factory;
    private Transform<Record, Tuple<NodeId>> transformToTuple = new Transform<Record, Tuple<NodeId>>(){

        @Override
        public Tuple<NodeId> convert(Record item) {
            return TupleLib.tuple(item, TupleIndexRecord.this.colMap);
        }
    };

    public TupleIndexRecord(int N, ColumnMap colMapping, RecordFactory factory, RangeIndex index) {
        super(N, colMapping);
        this.factory = factory;
        this.index = index;
        if (factory.keyLength() != N * 8) {
            throw new TDBException(String.format("Mismatch: TupleIndex of length %d is not comparative with a factory for key length %d", N, factory.keyLength()));
        }
    }

    @Override
    protected boolean performAdd(Tuple<NodeId> tuple) {
        Record r = TupleLib.record(this.factory, tuple, this.colMap);
        return this.index.add(r);
    }

    @Override
    protected boolean performDelete(Tuple<NodeId> tuple) {
        Record r = TupleLib.record(this.factory, tuple, this.colMap);
        return this.index.delete(r);
    }

    @Override
    protected Iterator<Tuple<NodeId>> performFind(Tuple<NodeId> pattern) {
        return this.findOrScan(pattern);
    }

    final Iterator<Tuple<NodeId>> findOrScan(Tuple<NodeId> pattern) {
        return this.findWorker(pattern, true, true);
    }

    final Iterator<Tuple<NodeId>> findOrPartialScan(Tuple<NodeId> pattern) {
        return this.findWorker(pattern, true, false);
    }

    final Iterator<Tuple<NodeId>> findByIndex(Tuple<NodeId> pattern) {
        return this.findWorker(pattern, false, false);
    }

    private Iterator<Tuple<NodeId>> findWorker(Tuple<NodeId> pattern, boolean partialScanAllowed, boolean fullScanAllowed) {
        NodeId X;
        pattern = this.colMap.map(pattern);
        int numSlots = 0;
        int leadingIdx = -2;
        boolean leading = true;
        Record minRec = this.factory.createKeyOnly();
        Record maxRec = this.factory.createKeyOnly();
        for (int i = 0; i < pattern.size(); ++i) {
            X = pattern.get(i);
            if (NodeId.isAny(X)) {
                X = null;
            }
            if (X != null) {
                ++numSlots;
                if (!leading) continue;
                leadingIdx = i;
                Bytes.setLong(X.getId(), minRec.getKey(), i * 8);
                Bytes.setLong(X.getId(), maxRec.getKey(), i * 8);
                continue;
            }
            leading = false;
        }
        if (numSlots == pattern.size()) {
            if (this.index.contains(minRec)) {
                return new SingletonIterator<Tuple<NodeId>>(pattern);
            }
            return new NullIterator<Tuple<NodeId>>();
        }
        Iterator<Record> iter = null;
        if (leadingIdx < 0) {
            if (!fullScanAllowed) {
                return null;
            }
            iter = this.index.iterator();
        } else {
            X = pattern.get(leadingIdx);
            Bytes.setLong(X.getId() + 1L, maxRec.getKey(), leadingIdx * 8);
            iter = this.index.iterator(minRec, maxRec);
        }
        Iterator<Tuple<NodeId>> tuples = Iter.map(iter, this.transformToTuple);
        if (leadingIdx < numSlots - 1) {
            if (!partialScanAllowed) {
                return null;
            }
            tuples = this.scan(tuples, pattern);
        }
        return tuples;
    }

    @Override
    public Iterator<Tuple<NodeId>> all() {
        Iterator<Record> iter = this.index.iterator();
        return Iter.map(iter, this.transformToTuple);
    }

    private Iterator<Tuple<NodeId>> scan(Iterator<Tuple<NodeId>> iter, final Tuple<NodeId> pattern) {
        Filter<Tuple<NodeId>> filter = new Filter<Tuple<NodeId>>(){

            @Override
            public boolean accept(Tuple<NodeId> item) {
                for (int i = 0; i < TupleIndexRecord.this.tupleLength; ++i) {
                    NodeId n = (NodeId)pattern.get(i);
                    if (NodeId.isAny(n) || item.get(i).equals(pattern.get(i))) continue;
                    return false;
                }
                return true;
            }
        };
        return Iter.filter(iter, filter);
    }

    @Override
    public void close() {
        this.index.close();
    }

    @Override
    public void sync() {
        this.sync(true);
    }

    @Override
    public void sync(boolean force) {
        this.index.sync(force);
    }

    public final RangeIndex getRangeIndex() {
        return this.index;
    }

    @Override
    public boolean isEmpty() {
        return this.index.isEmpty();
    }

    @Override
    public void clear() {
        this.index.clear();
    }

    @Override
    public long size() {
        return this.index.size();
    }
}

