/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.tdb.index;

import com.hp.hpl.jena.tdb.TDBException;
import com.hp.hpl.jena.tdb.index.TupleIndex;
import com.hp.hpl.jena.tdb.store.NodeId;
import java.util.Iterator;
import org.openjena.atlas.lib.ColumnMap;
import org.openjena.atlas.lib.Tuple;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class TupleIndexBase
implements TupleIndex {
    private static final boolean Check = true;
    protected final ColumnMap colMap;
    protected final int tupleLength;

    protected TupleIndexBase(int N, ColumnMap colMapping) {
        this.tupleLength = N;
        this.colMap = colMapping;
    }

    protected abstract boolean performAdd(Tuple<NodeId> var1);

    protected abstract boolean performDelete(Tuple<NodeId> var1);

    protected abstract Iterator<Tuple<NodeId>> performFind(Tuple<NodeId> var1);

    @Override
    public final boolean add(Tuple<NodeId> tuple) {
        if (this.tupleLength != tuple.size()) {
            throw new TDBException(String.format("Mismatch: tuple length %d / index for length %d", tuple.size(), this.tupleLength));
        }
        return this.performAdd(tuple);
    }

    @Override
    public final boolean delete(Tuple<NodeId> tuple) {
        if (this.tupleLength != tuple.size()) {
            throw new TDBException(String.format("Mismatch: tuple length %d / index for length %d", tuple.size(), this.tupleLength));
        }
        return this.performDelete(tuple);
    }

    @Override
    public final Iterator<Tuple<NodeId>> find(Tuple<NodeId> pattern) {
        if (this.tupleLength != pattern.size()) {
            throw new TDBException(String.format("Mismatch: tuple length %d / index for length %d", pattern.size(), this.tupleLength));
        }
        return this.performFind(pattern);
    }

    @Override
    public final int weight(Tuple<NodeId> pattern) {
        for (int i = 0; i < this.tupleLength; ++i) {
            NodeId X = this.colMap.fetchSlot(i, pattern);
            if (!this.undef(X)) continue;
            return i;
        }
        return this.tupleLength;
    }

    @Override
    public final String getLabel() {
        return this.colMap.getLabel();
    }

    @Override
    public final int getTupleLength() {
        return this.tupleLength;
    }

    public final ColumnMap getColumnMap() {
        return this.colMap;
    }

    protected final boolean undef(NodeId x) {
        return NodeId.isAny(x);
    }

    public String toString() {
        return "index:" + this.getLabel();
    }
}

