/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.tdb.base.recordfile;

import com.hp.hpl.jena.tdb.base.buffer.RecordBuffer;
import com.hp.hpl.jena.tdb.base.page.PageBase;
import com.hp.hpl.jena.tdb.base.record.RecordFactory;
import java.nio.ByteBuffer;
import org.openjena.atlas.io.IndentedWriter;

public class RecordBufferPageBase
extends PageBase {
    public static final int COUNT = 0;
    private static final int FIELD_LENGTH = 4;
    protected final int headerLength;
    protected RecordBuffer recBuff;

    public static int calcRecordSize(RecordFactory factory, int blkSize, int headerOffset) {
        int x = blkSize - RecordBufferPageBase.totalOffset(headerOffset);
        return x / factory.recordLength();
    }

    public static int calcBlockSize(RecordFactory factory, int maxRec, int headerOffset) {
        return RecordBufferPageBase.totalOffset(headerOffset) + factory.recordLength() * maxRec;
    }

    private static int totalOffset(int headerOffset) {
        return 4 + headerOffset;
    }

    protected RecordBufferPageBase(int id, int offset, ByteBuffer byteBuffer, RecordFactory factory, int count) {
        super(id, byteBuffer);
        this.headerLength = 4 + offset;
        byteBuffer.position(this.headerLength);
        ByteBuffer bb = byteBuffer.slice();
        this.recBuff = new RecordBuffer(bb, factory, count);
    }

    public final RecordBuffer getRecordBuffer() {
        return this.recBuff;
    }

    public final int getCount() {
        return this.recBuff.size();
    }

    public final int getMaxSize() {
        return this.recBuff.maxSize();
    }

    public void setCount(int count) {
        this.recBuff.setSize(count);
    }

    public String toString() {
        return String.format("RecordBufferPageBase[id=%d]: %s", this.getId(), this.recBuff);
    }

    public void output(IndentedWriter out) {
        out.print(this.toString());
    }
}

