/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.tdb.base.record;

import com.hp.hpl.jena.tdb.base.record.RecordException;
import com.hp.hpl.jena.tdb.sys.SystemTDB;
import java.util.Arrays;
import org.openjena.atlas.lib.Bytes;

public final class Record {
    public static final Record NO_REC = null;
    private final byte[] key;
    private final byte[] value;

    public Record(byte[] key, byte[] value) {
        this.key = key;
        this.value = value;
        if (SystemTDB.Checking && value != null && value.length == 0) {
            throw new RecordException("Zero length value");
        }
    }

    public byte[] getKey() {
        return this.key;
    }

    public byte[] getValue() {
        return this.value;
    }

    public boolean hasSeparateValue() {
        return this.value != null;
    }

    public int hashCode() {
        return Arrays.hashCode(this.key) ^ Arrays.hashCode(this.value);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Record)) {
            return false;
        }
        Record r = (Record)other;
        return Record.compareByKeyValue(this, r) == 0;
    }

    public String toString() {
        if (this.value == null) {
            return Record.str(this.key);
        }
        return Record.str(this.key) + ":" + Record.str(this.value);
    }

    public static boolean keyEQ(Record record1, Record record2) {
        int x = Record.compareByKey(record1, record2);
        return x == 0;
    }

    public static boolean keyNE(Record record1, Record record2) {
        int x = Record.compareByKey(record1, record2);
        return x != 0;
    }

    public static boolean keyLT(Record record1, Record record2) {
        int x = Record.compareByKey(record1, record2);
        return x < 0;
    }

    public static boolean keyLE(Record record1, Record record2) {
        int x = Record.compareByKey(record1, record2);
        return x <= 0;
    }

    public static boolean keyGE(Record record1, Record record2) {
        int x = Record.compareByKey(record1, record2);
        return x >= 0;
    }

    public static boolean keyGT(Record record1, Record record2) {
        int x = Record.compareByKey(record1, record2);
        return x > 0;
    }

    public static boolean equals(Record record1, Record record2) {
        int x = Record.compareByKeyValue(record1, record2);
        return x == 0;
    }

    public static String str(byte[] b) {
        StringBuilder str2 = new StringBuilder();
        for (int i = 0; i < b.length; ++i) {
            str2.append(String.format("%02x", b[i]));
        }
        return str2.toString();
    }

    public static int compareByKey(Record record1, Record record2) {
        Record.checkKeyCompatible(record1, record2);
        return Bytes.compare(record1.key, record2.key);
    }

    public static int compareByKeyValue(Record record1, Record record2) {
        Record.checkCompatible(record1, record2);
        int x = Bytes.compare(record1.key, record2.key);
        if (x == 0 && record1.value != null) {
            x = Bytes.compare(record1.value, record2.value);
        }
        return x;
    }

    static void checkCompatible(Record record1, Record record2) {
        if (!Record.compatible(record1, record2, true)) {
            throw new RecordException(String.format("Incompatible: %s, %s", record1, record2));
        }
    }

    static void checkKeyCompatible(Record record1, Record record2) {
        if (!Record.compatible(record1, record2, false)) {
            throw new RecordException(String.format("Incompatible: %s, %s", record1, record2));
        }
    }

    static boolean compatible(Record record1, Record record2, boolean checkValue) {
        if (record1.key.length != record2.key.length) {
            return false;
        }
        if (checkValue) {
            if (record1.value == null && record2.value == null) {
                return true;
            }
            if (record1.value == null) {
                return false;
            }
            if (record2.value == null) {
                return false;
            }
            if (record1.value.length != record2.value.length) {
                return false;
            }
        }
        return true;
    }
}

