/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.tdb.base.file;

import com.hp.hpl.jena.tdb.base.file.Location;
import com.hp.hpl.jena.tdb.base.file.MetaFile;
import java.io.File;
import org.openjena.atlas.lib.FileOps;
import org.openjena.atlas.lib.Tuple;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileSet {
    private static Logger log = LoggerFactory.getLogger(FileSet.class);
    private Location location;
    private String basename;
    private MetaFile metafile;
    private boolean isInMemory;

    public static FileSet mem() {
        FileSet fs = new FileSet(Location.mem(), "mem");
        return fs;
    }

    public FileSet(String directory, String basename) {
        this.initFileSet(new Location(directory), basename);
    }

    public FileSet(String filename) {
        Tuple<String> t = FileOps.splitDirFile(filename);
        String dir = t.get(0);
        String fn = t.get(1);
        if (dir == null) {
            dir = ".";
        }
        this.initFileSet(new Location(dir), fn);
    }

    public FileSet(Location directory, String basename) {
        this.initFileSet(directory, basename);
    }

    private void initFileSet(Location directory, String basename) {
        this.initFileSet(directory, basename, false);
    }

    private void initFileSet(Location directory, String basename, boolean useLocationMetadata) {
        this.location = directory;
        this.basename = basename;
        this.isInMemory = this.location.isMem();
        if (this.isInMemory) {
            this.metafile = useLocationMetadata ? this.location.getMetaFile() : new MetaFile("Fileset: memory", "--mem--");
            return;
        }
        String metaFileName = this.location.getPath(basename, "info");
        this.metafile = useLocationMetadata ? this.location.getMetaFile() : new MetaFile("Fileset: " + this.basename, metaFileName);
    }

    public Location getLocation() {
        return this.location;
    }

    public String getBasename() {
        return this.basename;
    }

    public MetaFile getMetaFile() {
        return this.metafile;
    }

    public boolean isMem() {
        return this.location.isMem();
    }

    public boolean exists(String ext) {
        if (this.isInMemory) {
            return true;
        }
        String fn = this.filename(ext);
        File f = new File(fn);
        if (f.isDirectory()) {
            log.warn("File clashes with a directory");
        }
        return f.exists() && f.isFile();
    }

    public String toString() {
        return "FileSet:" + this.filename(null);
    }

    public String filename(String ext) {
        return this.location.getPath(this.basename, ext);
    }
}

