/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.tdb.base.block;

import com.hp.hpl.jena.tdb.base.block.BlockException;
import com.hp.hpl.jena.tdb.base.block.BlockMgrBase;
import com.hp.hpl.jena.tdb.sys.SystemTDB;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class BlockMgrMem
extends BlockMgrBase {
    private static final boolean Checking = true;
    private static Logger log = LoggerFactory.getLogger(BlockMgrMem.class);
    private List<ByteBuffer> blocks = new ArrayList<ByteBuffer>();
    private Stack<Integer> freeBlocks = new Stack();
    private static ByteBuffer FreeBlock = ByteBuffer.allocate(0);
    public static boolean SafeMode = true;
    private final boolean safeModeThisMgr;

    BlockMgrMem(int blockSize) {
        this(blockSize, SafeMode);
    }

    BlockMgrMem(int blockSize, boolean safeMode) {
        super(blockSize);
        this.safeModeThisMgr = safeMode;
    }

    public int allocateId() {
        int idx = -1;
        if (!this.freeBlocks.isEmpty()) {
            idx = this.freeBlocks.pop();
            this.blocks.set(idx, null);
            return idx;
        }
        int x = this.blocks.size();
        this.blocks.add(null);
        if (log.isDebugEnabled()) {
            log.debug(String.format("allocate() : %d", x));
        }
        return x;
    }

    public ByteBuffer allocateBuffer(int id) {
        ByteBuffer bb = ByteBuffer.allocate(this.blockSize);
        ByteBuffer bb2 = this.blocks.get(id);
        if (bb2 != null) {
            throw new BlockException("Block overwrite: " + id);
        }
        this.blocks.set(id, bb);
        return bb;
    }

    public ByteBuffer get(int id) {
        this.check(id);
        ByteBuffer bb = this.blocks.get(id);
        if (bb == null) {
            throw new BlockException("Null block: " + id);
        }
        if (bb == FreeBlock) {
            throw new BlockException("Free block: " + id);
        }
        if (log.isDebugEnabled()) {
            log.debug(String.format("get(%d) : %s", id, bb));
        }
        if (this.safeModeThisMgr) {
            bb = BlockMgrMem.replicate(bb);
        }
        return bb;
    }

    public boolean valid(int id) {
        if (id >= this.blocks.size()) {
            return false;
        }
        if (id < 0) {
            return false;
        }
        ByteBuffer bb = this.blocks.get(id);
        return bb != FreeBlock && bb != null;
    }

    public void put(int id, ByteBuffer block) {
        this.check(id, block);
        if (log.isDebugEnabled()) {
            log.debug(String.format("put(%d,)", id));
        }
        if (this.safeModeThisMgr) {
            block = BlockMgrMem.replicate(block);
        }
        this.blocks.set(id, block);
    }

    public void freeBlock(int id) {
        this.check(id);
        if (log.isDebugEnabled()) {
            log.debug(String.format("release(%d)", id));
        }
        if (this.isFree(id)) {
            throw new BlockException("Already free: " + id);
        }
        this.blocks.set(id, FreeBlock);
        this.freeBlocks.push(id);
    }

    private boolean isFree(int id) {
        return this.blocks.get(id) == FreeBlock;
    }

    public void sync(boolean force) {
    }

    public boolean isClosed() {
        return this.blocks == null;
    }

    public void close() {
        this.blocks = null;
        this.freeBlocks = null;
    }

    public boolean isEmpty() {
        return this.blocks.size() == 0;
    }

    private static ByteBuffer replicate(ByteBuffer srcBlk) {
        ByteBuffer dstBlk = ByteBuffer.allocate(srcBlk.capacity());
        System.arraycopy(srcBlk.array(), 0, dstBlk.array(), 0, srcBlk.capacity());
        return dstBlk;
    }

    private void check(int id) {
        if (id < 0 || id >= this.blocks.size()) {
            throw new BlockException("BlockMgrMem: Bounds exception: " + id);
        }
        if (this.isFree(id)) {
            throw new BlockException("BlockMgrMem: Block is the free block: " + id);
        }
    }

    private void check(int id, ByteBuffer bb) {
        this.check(id);
        if (bb.capacity() != this.blockSize) {
            throw new BlockException(String.format("BlockMgrMem: Wrong size block.  Expected=%d : actual=%d", this.blockSize, bb.capacity()));
        }
        if (bb.order() != SystemTDB.NetworkOrder) {
            throw new BlockException("BlockMgrMem: Wrong byte order");
        }
    }

    public String toString() {
        return String.format("BlockMgrMem[%d bytes]", this.blockSize);
    }

    protected Logger getLog() {
        return log;
    }
}

