/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.sse.lang;

import com.hp.hpl.jena.datatypes.RDFDatatype;
import com.hp.hpl.jena.datatypes.TypeMapper;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.sparql.core.Var;
import com.hp.hpl.jena.sparql.core.VarAlloc;
import com.hp.hpl.jena.sparql.sse.Item;
import com.hp.hpl.jena.sparql.sse.ItemList;
import com.hp.hpl.jena.sparql.sse.ItemLocation;
import com.hp.hpl.jena.sparql.sse.SSEParseException;
import com.hp.hpl.jena.sparql.sse.lang.ParseHandler;
import com.hp.hpl.jena.sparql.util.LabelToNodeMap;
import java.util.Stack;
import org.openjena.atlas.logging.Log;

public class ParseHandlerPlain
implements ParseHandler {
    private ListStack listStack = new ListStack();
    private Item currentItem = null;
    private int depth = 0;
    private LabelToNodeMap bNodeLabels = LabelToNodeMap.createBNodeMap();
    private VarAlloc varAlloc = new VarAlloc("_");
    private VarAlloc varAllocND = new VarAlloc("?");
    private VarAlloc varAllocIntern = new VarAlloc(".");

    public Item getItem() {
        return this.currentItem;
    }

    public void parseStart() {
        this.depth = 0;
    }

    public void parseFinish() {
        if (this.depth != 0) {
            Log.warn(this, "Stack error: depth =" + this.depth + " at end of parse run");
        }
        this.depth = -1;
    }

    public void listStart(int line, int column) {
        ItemList list = new ItemList(line, column);
        this.pushList(list);
        this.setCurrentItem(Item.createList(list));
    }

    public void listFinish(int line, int column) {
        ItemList list = this.popList();
        Item item = Item.createList(list);
        this.listAdd(item);
    }

    protected void setCurrentItem(Item item) {
        this.currentItem = item;
    }

    protected void listAdd(Item item) {
        if (this.listStack.isEmpty()) {
            this.setCurrentItem(item);
            return;
        }
        if (item != null) {
            ItemList list = this.currentList();
            list.add(item);
        }
        this.setCurrentItem(item);
    }

    public void emitSymbol(int line, int column, String symbol) {
        this.listAdd(Item.createSymbol(symbol, line, column));
    }

    public void emitVar(int line, int column, String varName) {
        Var var = null;
        var = varName.equals("") ? this.varAlloc.allocVar() : (varName.equals("?") ? this.varAllocND.allocVar() : (varName.equals(".") ? this.varAllocIntern.allocVar() : Var.alloc(varName)));
        Item item = Item.createNode(var, line, column);
        this.listAdd(item);
    }

    public void emitLiteral(int line, int column, String lexicalForm, String langTag, String datatypeIRI, String datatypePN) {
        Node n = null;
        if (datatypeIRI != null || datatypePN != null) {
            if (datatypePN != null) {
                datatypeIRI = this.resolvePrefixedName(datatypePN, line, column);
            }
            RDFDatatype dType = TypeMapper.getInstance().getSafeTypeByName(datatypeIRI);
            n = Node.createLiteral(lexicalForm, null, dType);
        } else {
            n = Node.createLiteral(lexicalForm, langTag, null);
        }
        Item item = Item.createNode(n, line, column);
        this.listAdd(item);
    }

    public final void emitBNode(int line, int column, String label) {
        Node n = null;
        n = label.equals("") ? Node.createAnon() : this.bNodeLabels.asNode(label);
        Item item = Item.createNode(n, line, column);
        this.listAdd(item);
    }

    public void emitIRI(int line, int column, String iriStr) {
        Node n = Node.createURI(iriStr);
        Item item = Item.createNode(n, line, column);
        this.listAdd(item);
    }

    public void emitPName(int line, int column, String pname) {
        String iriStr = this.resolvePrefixedName(pname, line, column);
        this.emitIRI(line, column, iriStr);
    }

    protected ItemList currentList() {
        return this.listStack.getCurrent();
    }

    protected ItemList popList() {
        --this.depth;
        this.setCurrentItem(null);
        return this.listStack.pop();
    }

    protected void pushList(ItemList list) {
        this.listStack.push(list);
        ++this.depth;
    }

    protected String resolvePrefixedName(String pname, int line, int column) {
        return "pname:" + pname;
    }

    protected static void throwException(String msg, int line, int column) {
        throw new SSEParseException("[" + line + ", " + column + "] " + msg, line, column);
    }

    protected static void throwException(String msg, ItemLocation loc) {
        ParseHandlerPlain.throwException(msg, loc.getLine(), loc.getColumn());
    }

    protected static class ListStack {
        private Stack<ItemList> stack = new Stack();

        protected ListStack() {
        }

        boolean isEmpty() {
            return this.stack.size() == 0;
        }

        ItemList getCurrent() {
            if (this.stack.size() == 0) {
                return null;
            }
            return this.stack.peek();
        }

        void push(ItemList list) {
            this.stack.push(list);
        }

        ItemList pop() {
            return this.stack.pop();
        }
    }
}

