/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.sse.builders;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.shared.PrefixMapping;
import com.hp.hpl.jena.shared.impl.PrefixMappingImpl;
import com.hp.hpl.jena.sparql.sse.Item;
import com.hp.hpl.jena.sparql.sse.ItemList;
import com.hp.hpl.jena.sparql.sse.ItemLocation;
import com.hp.hpl.jena.sparql.sse.builders.BuilderLib;
import org.openjena.atlas.lib.StrUtils;

public class BuilderPrefixMapping {
    public static PrefixMapping build(Item elt) {
        PrefixMappingImpl pmap = new PrefixMappingImpl();
        BuilderPrefixMapping.build(pmap, elt);
        return pmap;
    }

    public static void build(PrefixMapping newMappings, Item elt) {
        if (!elt.isList()) {
            BuilderLib.broken((ItemLocation)elt, "Prefix mapping requires a list of pairs", elt);
        }
        ItemList prefixes = elt.getList();
        if (elt.isTaggedIgnoreCase("prefixmap") || elt.isTaggedIgnoreCase("prefixmapping")) {
            BuilderLib.checkLength(2, elt.getList(), "Not of length 2" + elt.shortString());
            prefixes = prefixes.cdr();
        }
        for (Item pair : prefixes) {
            Node iriNode;
            if (!pair.isList() || pair.getList().size() != 2) {
                BuilderLib.broken(pair, "Not a prefix/IRI pair");
            }
            Item prefixItem = pair.getList().get(0);
            Item iriItem = pair.getList().get(1);
            String prefix = null;
            if (prefixItem.isSymbol()) {
                prefix = prefixItem.getSymbol();
            }
            if (prefix == null) {
                BuilderLib.broken(pair, "Prefix part not recognized: " + prefixItem);
            }
            if (!prefix.endsWith(":")) {
                BuilderLib.broken(pair, "Prefix part does not end with a ':': " + pair);
            }
            if (StrUtils.contains(prefix = prefix.substring(0, prefix.length() - 1), ":")) {
                BuilderLib.broken(pair, "Prefix itself contains a ':' : " + pair);
            }
            if ((iriNode = iriItem.getNode()) == null || !iriNode.isURI()) {
                BuilderLib.broken(pair, "Not an IRI: " + iriItem);
            }
            String iri2 = iriNode.getURI();
            newMappings.setNsPrefix(prefix, iri2);
        }
    }
}

