/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.sse.builders;

import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.sparql.core.DatasetGraph;
import com.hp.hpl.jena.sparql.core.DatasetGraphFactory;
import com.hp.hpl.jena.sparql.core.Quad;
import com.hp.hpl.jena.sparql.sse.Item;
import com.hp.hpl.jena.sparql.sse.ItemList;
import com.hp.hpl.jena.sparql.sse.ItemLocation;
import com.hp.hpl.jena.sparql.sse.builders.BuilderLib;
import com.hp.hpl.jena.sparql.sse.builders.BuilderNode;
import com.hp.hpl.jena.sparql.util.NodeUtils;
import com.hp.hpl.jena.sparql.util.graph.GraphFactory;
import com.hp.hpl.jena.util.FileManager;

public class BuilderGraph {
    public static Graph buildGraph(Item item) {
        Graph graph = GraphFactory.createDefaultGraph();
        BuilderGraph.buildGraph(graph, item);
        return graph;
    }

    public static Graph buildGraph(ItemList itemList) {
        Graph graph = GraphFactory.createDefaultGraph();
        BuilderGraph.buildGraph(graph, itemList);
        return graph;
    }

    public static void buildGraph(Graph graph, Item item) {
        if (item.isNode()) {
            BuilderLib.broken(item, "Attempt to build graph from a plain node");
        }
        if (item.isSymbol()) {
            BuilderLib.broken(item, "Attempt to build graph from a bare symbol");
        }
        if (item.isTagged("graph")) {
            BuilderGraph.buildGraph(graph, item.getList());
            return;
        }
        if (item.isTagged("graph@")) {
            BuilderGraph.loadGraph(graph, item.getList());
            return;
        }
        BuilderLib.broken(item, "Wanted (graph...) or (graph@...)");
    }

    public static Graph buildGraph(Graph graph, ItemList list) {
        if (!list.isEmpty() && list.get(0).isSymbol() && list.get(0).isSymbol("graph")) {
            list = list.cdr();
        }
        for (Item item : list) {
            BuilderLib.checkList(item);
            Triple triple = BuilderGraph.buildTriple(item.getList());
            graph.add(triple);
        }
        return graph;
    }

    public static DatasetGraph buildDataset(Item item) {
        if (item.isNode()) {
            BuilderLib.broken(item, "Attempt to build dataset from a plain node");
        }
        if (item.isSymbol()) {
            BuilderLib.broken(item, "Attempt to build dataset from a bare symbol");
        }
        if (item.isTagged("graph")) {
            Graph g = BuilderGraph.buildGraph(item.getList());
            return DatasetGraphFactory.create(g);
        }
        if (!item.isTagged("dataset")) {
            BuilderLib.broken(item, "Wanted (dataset...)");
        }
        return BuilderGraph.buildDataset(item.getList());
    }

    public static DatasetGraph buildDataset(ItemList list) {
        BuilderLib.checkTag(list, "dataset");
        list = list.cdr();
        DatasetGraph ds = DatasetGraphFactory.createMem();
        for (Item item : list) {
            Graph g;
            if (!item.isTagged("graph")) {
                BuilderLib.broken(item, "Expected (graph ...) as elements of a dataset");
            }
            Node name = null;
            ItemList graphContent = item.getList().cdr();
            if (!graphContent.isEmpty() && graphContent.car().isNode()) {
                name = graphContent.car().getNode();
                graphContent = graphContent.cdr();
            }
            if (name == null) {
                g = ds.getDefaultGraph();
                if (g == null) {
                    g = GraphFactory.createDefaultGraph();
                    ds.setDefaultGraph(g);
                }
            } else {
                g = ds.getGraph(name);
                if (g == null) {
                    g = GraphFactory.createDefaultGraph();
                    ds.addGraph(name, g);
                }
            }
            BuilderGraph.buildGraph(g, graphContent);
        }
        return ds;
    }

    private static void loadGraph(Graph graph, ItemList list) {
        String s;
        BuilderLib.checkLength(2, list, "graph@");
        Item item = list.get(1);
        if (!item.isNode()) {
            BuilderLib.broken(item, "Expected: (graph@ 'filename')");
        }
        if ((s = NodeUtils.stringLiteral(item.getNode())) == null) {
            BuilderLib.broken(item, "Expected: (graph@ 'filename')");
        }
        Model model = ModelFactory.createModelForGraph(graph);
        FileManager.get().readModel(model, s);
    }

    public static Triple buildTriple(ItemList list) {
        if (list.size() != 3 && list.size() != 4) {
            BuilderLib.broken((ItemLocation)list, "Not a triple", list);
        }
        if (list.size() == 4) {
            if (!list.get(0).isSymbol("triple")) {
                BuilderLib.broken(list, "Not a triple");
            }
            list = list.cdr();
        }
        return BuilderGraph._buildNode3(list);
    }

    public static Triple buildNode3(ItemList list) {
        BuilderLib.checkLength(3, list, null);
        return BuilderGraph._buildNode3(list);
    }

    private static Triple _buildNode3(ItemList list) {
        Node s = BuilderNode.buildNode(list.get(0));
        Node p = BuilderNode.buildNode(list.get(1));
        Node o = BuilderNode.buildNode(list.get(2));
        return new Triple(s, p, o);
    }

    public static Quad buildQuad(ItemList list) {
        if (list.size() != 4 && list.size() != 5) {
            BuilderLib.broken(list, "Not a quad");
        }
        if (list.size() == 5) {
            if (!list.get(0).isSymbol("quad")) {
                BuilderLib.broken(list, "Not a quad");
            }
            list = list.cdr();
        }
        return BuilderGraph._buildNode4(list);
    }

    public static Quad buildNode4(ItemList list) {
        BuilderLib.checkLength(4, list, null);
        return BuilderGraph._buildNode4(list);
    }

    private static Quad _buildNode4(ItemList list) {
        Node g = null;
        g = list.get(0).equals(Item.defaultItem) ? Quad.defaultGraphNodeGenerated : BuilderNode.buildNode(list.get(0));
        Node s = BuilderNode.buildNode(list.get(1));
        Node p = BuilderNode.buildNode(list.get(2));
        Node o = BuilderNode.buildNode(list.get(3));
        return new Quad(g, s, p, o);
    }
}

