/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.sse;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.shared.PrefixMapping;
import com.hp.hpl.jena.sparql.serializer.SerializationContext;
import com.hp.hpl.jena.sparql.sse.Item;
import com.hp.hpl.jena.sparql.sse.ItemList;
import com.hp.hpl.jena.sparql.sse.ItemVisitor;
import com.hp.hpl.jena.sparql.util.FmtUtils;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.Map;
import org.openjena.atlas.io.IndentedWriter;

public class ItemWriter {
    public static boolean includeBase = false;
    private static boolean CloseSameLine = true;

    public static void write(IndentedWriter out, Item item, SerializationContext sCxt) {
        Print pv = new Print(out, sCxt);
        pv.startPrint();
        item.visit(pv);
        pv.finishPrint();
    }

    public static void write(OutputStream out, Item item) {
        IndentedWriter iw = new IndentedWriter(out);
        ItemWriter.write(iw, item, null);
        iw.ensureStartOfLine();
        iw.flush();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Print
    implements ItemVisitor {
        IndentedWriter out;
        SerializationContext sCxt;
        boolean doneBase = false;
        boolean donePrefix = false;

        Print(IndentedWriter out, SerializationContext sCxt) {
            if (sCxt == null) {
                sCxt = new SerializationContext();
            }
            this.out = out;
            this.sCxt = sCxt;
        }

        void startPrint() {
            if (this.sCxt != null) {
                PrefixMapping pmap;
                if (includeBase && this.sCxt.getBaseIRI() != null) {
                    this.out.print("(base ");
                    this.out.println(FmtUtils.stringForURI(this.sCxt.getBaseIRI()));
                    this.doneBase = true;
                    this.out.incIndent();
                }
                if ((pmap = this.sCxt.getPrefixMapping()) != null) {
                    Map<String, String> pm = pmap.getNsPrefixMap();
                    boolean bl = this.donePrefix = pm.size() != 0;
                    if (pm.size() != 0) {
                        this.out.println("(prefix");
                        this.out.incIndent();
                        this.printPrefixes(pm, this.out);
                        this.out.println();
                    }
                }
            }
        }

        void finishPrint() {
            if (this.doneBase) {
                this.out.print(")");
                this.out.decIndent();
            }
            if (this.donePrefix) {
                this.out.print(")");
                this.out.decIndent();
            }
        }

        @Override
        public void visit(Item item, Node node) {
            this.out.print(FmtUtils.stringForNode(node, this.sCxt));
        }

        @Override
        public void visit(Item item, String symbol) {
            this.out.print(symbol);
        }

        @Override
        public void visit(Item item, ItemList list) {
            this.out.print("(");
            boolean listMode = false;
            for (Item subItem : list) {
                if (!subItem.isList()) continue;
                listMode = true;
                break;
            }
            if (listMode) {
                this.printAsList(list);
            } else {
                this.printOneLine(list);
            }
        }

        @Override
        public void visitNil() {
            this.out.print("nil");
        }

        private void printAsList(ItemList list) {
            boolean first = true;
            int indentlevel = this.out.getUnitIndent();
            if (list.size() >= 1 && list.get(0).isList()) {
                indentlevel = 1;
            }
            for (Item subItem : list) {
                if (!first) {
                    this.out.println();
                }
                subItem.visit(this);
                if (first) {
                    this.out.incIndent(indentlevel);
                }
                first = false;
            }
            if (!first) {
                this.out.decIndent(indentlevel);
            }
            if (!CloseSameLine) {
                this.out.println();
            }
            this.out.print(")");
        }

        private void printOneLine(ItemList list) {
            boolean first = true;
            for (Item subItem : list) {
                if (!first) {
                    this.out.print(" ");
                }
                first = false;
                subItem.visit(this);
            }
            this.out.print(")");
        }

        private void printPrefixes(Map<String, String> map, IndentedWriter out) {
            if (map.size() == 0) {
                return;
            }
            out.print("( ");
            out.incIndent(2);
            boolean first = true;
            Iterator<String> iter = map.keySet().iterator();
            while (iter.hasNext()) {
                if (!first) {
                    out.println();
                }
                first = false;
                String k = iter.next();
                String v = map.get(k);
                out.print("(");
                out.print(k);
                out.print(':');
                out.print(' ', 6 - k.length());
                out.print(FmtUtils.stringForURI(v));
                out.print(")");
            }
            out.decIndent(2);
            out.print(")");
        }
    }
}

