/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.lang.rdql;

import com.hp.hpl.jena.datatypes.xsd.XSDDatatype;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.QueryException;
import com.hp.hpl.jena.sparql.ARQInternalErrorException;
import com.hp.hpl.jena.sparql.core.Var;
import com.hp.hpl.jena.sparql.lang.rdql.ExprNodeRDQL;
import com.hp.hpl.jena.sparql.lang.rdql.ExprRDQL;
import com.hp.hpl.jena.sparql.lang.rdql.ParsedLiteral;
import com.hp.hpl.jena.sparql.lang.rdql.Q_ConstraintClause;
import com.hp.hpl.jena.sparql.lang.rdql.Q_Identifier;
import com.hp.hpl.jena.sparql.lang.rdql.Q_PrefixDecl;
import com.hp.hpl.jena.sparql.lang.rdql.Q_PrefixesClause;
import com.hp.hpl.jena.sparql.lang.rdql.Q_QName;
import com.hp.hpl.jena.sparql.lang.rdql.Q_SelectClause;
import com.hp.hpl.jena.sparql.lang.rdql.Q_SourceClause;
import com.hp.hpl.jena.sparql.lang.rdql.Q_TriplePattern;
import com.hp.hpl.jena.sparql.lang.rdql.Q_TriplePatternClause;
import com.hp.hpl.jena.sparql.lang.rdql.Q_URI;
import com.hp.hpl.jena.sparql.lang.rdql.Q_URL;
import com.hp.hpl.jena.sparql.lang.rdql.Q_Var;
import com.hp.hpl.jena.sparql.lang.rdql.RDQLParser;
import com.hp.hpl.jena.sparql.lang.rdql.RDQL_Node;
import com.hp.hpl.jena.sparql.lang.rdql.SimpleNode;
import com.hp.hpl.jena.sparql.syntax.ElementFilter;
import com.hp.hpl.jena.sparql.syntax.ElementGroup;
import java.util.ArrayList;
import java.util.List;
import org.openjena.atlas.logging.Log;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Q_Query
extends SimpleNode {
    private Query query = null;
    boolean constructStar = false;
    boolean selectAllVars = false;

    public Q_Query(int id) {
        super(id);
    }

    public Q_Query(RDQLParser p, int id) {
        super(p, id);
    }

    public void rdqlPhase2(Query q) {
        this.query = q;
        ElementGroup queryElement = new ElementGroup();
        this.query.setQueryPattern(queryElement);
        ArrayList<String> varAcc = new ArrayList<String>();
        try {
            this.postParse1(q);
            this.postParse2(q);
            int numQueryChildren = this.jjtGetNumChildren();
            int i = 0;
            if (this.jjtGetChild(i) instanceof Q_SelectClause) {
                this.query.setQuerySelectType();
                this.extractVarList(q, this.jjtGetChild(i));
                ++i;
            }
            if (q.isUnknownType()) {
                throw new ARQInternalErrorException("Parser didn't catch absence of SELECT clause");
            }
            if (i < numQueryChildren && this.jjtGetChild(i) instanceof Q_SourceClause) {
                int numSources = this.jjtGetChild(i).jjtGetNumChildren();
                if (numSources > 1) {
                    throw new QueryException("Error: Multiple sources in FROM clause");
                }
                for (int j = 0; j < numSources; ++j) {
                    RDQL_Node n = this.jjtGetChild(i).jjtGetChild(j).jjtGetChild(0);
                    String source = ((Q_URL)n).urlString;
                    q.addGraphURI(source);
                }
                ++i;
            }
            if (i < numQueryChildren && this.jjtGetChild(i) instanceof Q_TriplePatternClause) {
                this.makeElementTriplePatterns(q, this.jjtGetChild(i), queryElement, varAcc);
                ++i;
            }
            if (i < numQueryChildren && this.jjtGetChild(i) instanceof Q_ConstraintClause) {
                this.makeElementConstraints(q, queryElement, this.jjtGetChild(i));
                ++i;
            }
            if (this.constructStar) {
                // empty if block
            }
            if (this.selectAllVars) {
                this.query.setQueryResultStar(true);
                for (String varName : varAcc) {
                    q.addResultVar(varName);
                }
            }
        }
        catch (ARQInternalErrorException e2) {
            throw e2;
        }
        catch (QueryException qEx) {
            throw qEx;
        }
        catch (ClassCastException e3) {
            throw new ARQInternalErrorException("Parser generated illegal parse tree", e3);
        }
        catch (Exception e4) {
            Log.warn(this, "Unknown exception", (Throwable)e4);
            throw new ARQInternalErrorException("Unknown exception: " + e4);
        }
    }

    @Override
    public String toString() {
        throw new UnsupportedOperationException("Q_Query.toString()");
    }

    private void extractVarList(Query q, RDQL_Node node) {
        int n = node.jjtGetNumChildren();
        this.selectAllVars = n == 0;
        for (int i = 0; i < n; ++i) {
            RDQL_Node c = node.jjtGetChild(i);
            if (!(c instanceof Q_Var)) {
                throw new ARQInternalErrorException("Internal error: parser created '" + c.getClass().getName() + "' when Q_Var expected");
            }
            Q_Var v = (Q_Var)c;
            q.addResultVar(v.varName);
        }
    }

    private void extractVarOrURIList(Query q, RDQL_Node node) {
        int n = node.jjtGetNumChildren();
        this.selectAllVars = n == 0;
        for (int i = 0; i < n; ++i) {
            ExprNodeRDQL v;
            RDQL_Node c = node.jjtGetChild(i);
            if (c instanceof Q_Var) {
                v = (Q_Var)c;
                q.addResultVar(((Q_Var)v).varName);
                continue;
            }
            if (c instanceof Q_URI || c instanceof Q_QName) {
                v = (Q_URI)c;
                q.addDescribeNode(((ParsedLiteral)v).getNode());
                continue;
            }
            throw new ARQInternalErrorException("Internal error: parser created '" + c.getClass().getName() + "' when Q_Var expected");
        }
    }

    private void makeElementTriplePatterns(Query q, RDQL_Node node, ElementGroup group, List<String> varAcc) {
        int n = node.jjtGetNumChildren();
        for (int j = 0; j < n; ++j) {
            Q_TriplePattern tp = (Q_TriplePattern)node.jjtGetChild(j);
            if (tp.jjtGetNumChildren() != 3) {
                throw new ARQInternalErrorException("Triple pattern has " + tp.jjtGetNumChildren() + " children");
            }
            Node nodeSubj = Q_Query.convertToGraphNode(tp.jjtGetChild(0), q, varAcc);
            Node nodePred = Q_Query.convertToGraphNode(tp.jjtGetChild(1), q, varAcc);
            Node nodeObj = Q_Query.convertToGraphNode(tp.jjtGetChild(2), q, varAcc);
            Triple t = new Triple(nodeSubj, nodePred, nodeObj);
            group.addTriplePattern(t);
        }
    }

    private void extractFixedTriplePatterns(Query q, List<Triple> triplePatterns, RDQL_Node node, List<String> varAcc) {
        int n = node.jjtGetNumChildren();
        for (int j = 0; j < n; ++j) {
            Q_TriplePattern tp = (Q_TriplePattern)node.jjtGetChild(j);
            if (tp.jjtGetNumChildren() != 3) {
                throw new ARQInternalErrorException("Triple pattern has " + tp.jjtGetNumChildren() + " children");
            }
            Node nodeSubj = Q_Query.convertToGraphNode(tp.jjtGetChild(0), q, varAcc);
            Node nodePred = Q_Query.convertToGraphNode(tp.jjtGetChild(1), q, varAcc);
            Node nodeObj = Q_Query.convertToGraphNode(tp.jjtGetChild(2), q, varAcc);
            triplePatterns.add(new Triple(nodeSubj, nodePred, nodeObj));
        }
    }

    private static Node convertToGraphNode(RDQL_Node n, Query q, List<String> varAcc) {
        if (n instanceof Q_Var) {
            String varName = ((Q_Var)n).getName();
            if (varAcc != null) {
                varAcc.add(varName);
            }
            return Var.alloc(((Q_Var)n).getName());
        }
        if (n instanceof ParsedLiteral) {
            ParsedLiteral v = (ParsedLiteral)n;
            if (v.isNode()) {
                return v.getNode();
            }
            if (v.isURI()) {
                return Node.createURI(v.getURI());
            }
            if (v.isString()) {
                return Node.createLiteral(v.getString(), null, null);
            }
            if (v.isBoolean()) {
                return Node.createLiteral(v.asUnquotedString(), null, null);
            }
            if (v.isInt()) {
                return Node.createLiteral(v.asUnquotedString(), null, XSDDatatype.XSDinteger);
            }
            if (v.isDouble()) {
                return Node.createLiteral(v.asUnquotedString(), null, XSDDatatype.XSDdouble);
            }
            String s = v.getString();
            Log.fatal(Q_Query.class, "Failed to convert: " + s);
        }
        throw new ARQInternalErrorException("convertToGraphNode encountered strange type: " + n.getClass().getName());
    }

    private void makeElementConstraints(Query q, ElementGroup g, RDQL_Node node) {
        Q_ConstraintClause qcc = (Q_ConstraintClause)node;
        int n = qcc.jjtGetNumChildren();
        for (int j = 0; j < n; ++j) {
            RDQL_Node obj = qcc.jjtGetChild(j);
            if (!(obj instanceof ExprRDQL)) {
                throw new ARQInternalErrorException("Parse node in AND clause isn't a Constraint");
            }
            ElementFilter f = new ElementFilter((ExprRDQL)((Object)obj));
            g.addElementFilter(f);
        }
    }

    private void extractPrefixes(Query q, Q_PrefixesClause qns) {
        if (qns == null) {
            return;
        }
        int n = qns.jjtGetNumChildren();
        for (int j = 0; j < n; ++j) {
            Q_PrefixDecl qnsd = (Q_PrefixDecl)qns.jjtGetChild(j);
            for (int k = 0; k < qnsd.jjtGetNumChildren(); k += 2) {
                Q_Identifier id = (Q_Identifier)qnsd.jjtGetChild(k);
                Q_URI uri = (Q_URI)qnsd.jjtGetChild(k + 1);
                this.query.setPrefix(id.toString(), uri.toString());
            }
        }
    }
}

