/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.lang.rdql;

import com.hp.hpl.jena.graph.query.Expression;
import com.hp.hpl.jena.graph.query.IndexValues;
import com.hp.hpl.jena.graph.query.Valuator;
import com.hp.hpl.jena.graph.query.VariableIndexes;
import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.sparql.ARQInternalErrorException;
import com.hp.hpl.jena.sparql.core.Var;
import com.hp.hpl.jena.sparql.engine.binding.Binding;
import com.hp.hpl.jena.sparql.engine.binding.BindingIndex;
import com.hp.hpl.jena.sparql.expr.Expr;
import com.hp.hpl.jena.sparql.expr.ExprBuild;
import com.hp.hpl.jena.sparql.expr.ExprFunction;
import com.hp.hpl.jena.sparql.expr.ExprVar;
import com.hp.hpl.jena.sparql.expr.ExprVisitor;
import com.hp.hpl.jena.sparql.expr.ExprWalker;
import com.hp.hpl.jena.sparql.expr.NodeValue;
import com.hp.hpl.jena.sparql.function.FunctionEnv;
import com.hp.hpl.jena.sparql.graph.NodeTransform;
import com.hp.hpl.jena.sparql.lang.rdql.ExprRDQL;
import com.hp.hpl.jena.sparql.lang.rdql.Q_Var;
import com.hp.hpl.jena.sparql.lang.rdql.RDQLEvalFailureException;
import com.hp.hpl.jena.sparql.lang.rdql.RDQLParser;
import com.hp.hpl.jena.sparql.lang.rdql.RDQL_Node;
import com.hp.hpl.jena.sparql.lang.rdql.RDQL_NodeValue;
import com.hp.hpl.jena.sparql.lang.rdql.SimpleNode;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.openjena.atlas.io.IndentedWriter;
import org.openjena.atlas.logging.Log;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class ExprNodeRDQL
extends SimpleNode
implements Expression,
Valuator,
ExprRDQL {
    static final String exprBaseURI = "urn:x-jena:expr:";

    public ExprNodeRDQL(RDQLParser p, int i) {
        super(p, i);
    }

    public ExprNodeRDQL(int i) {
        super(i);
    }

    @Override
    public Expr copySubstitute(Binding binding) {
        return null;
    }

    @Override
    public Expr copySubstitute(Binding binding, boolean foldConstants) {
        return null;
    }

    @Override
    public Expr applyNodeTransform(NodeTransform transform) {
        return null;
    }

    @Override
    public Expr deepCopy() {
        return null;
    }

    @Override
    public NodeValue eval(Binding binding, FunctionEnv env) {
        return null;
    }

    @Override
    public NodeValue getConstant() {
        return null;
    }

    @Override
    public ExprVar getExprVar() {
        return null;
    }

    @Override
    public String getVarName() {
        return null;
    }

    @Override
    public Var asVar() {
        return null;
    }

    @Override
    public void visit(ExprVisitor visitor) {
        if (visitor instanceof ExprBuild) {
            return;
        }
        if (visitor instanceof ExprWalker.WalkerTopDown) {
            return;
        }
        if (visitor instanceof ExprWalker.WalkerBottomUp) {
            return;
        }
        throw new ARQInternalErrorException("Attempt to visit an RDQL expression");
    }

    @Override
    public boolean isSatisfied(Binding binding, FunctionEnv execCxt) {
        BindingIndex bInd;
        BindingIndex vi = bInd = new BindingIndex(binding);
        this.prepare(vi);
        BindingIndex iv = bInd;
        return this.isSatisfied(iv);
    }

    public boolean isSatisfied(IndexValues env) {
        return this.evalBool(env);
    }

    @Override
    public void postParse2(Query q) {
        super.postParse2(q);
    }

    @Override
    public Set<Var> getVarsMentioned() {
        HashSet<Var> acc = new HashSet<Var>();
        this.varsMentioned(acc);
        return acc;
    }

    public Set<String> getVarNamesMentioned() {
        HashSet<String> acc = new HashSet<String>();
        this.varNamesMentioned(acc);
        return acc;
    }

    public void varNamesMentioned(Collection<String> acc) {
        if (this instanceof Q_Var) {
            Q_Var v = (Q_Var)this;
            acc.add(v.getName());
            return;
        }
        for (int i = 0; i < this.argCount(); ++i) {
            Expression e2 = this.getArg(i);
            if (e2 == null) continue;
            ExprNodeRDQL ex = (ExprNodeRDQL)e2;
            ex.varNamesMentioned(acc);
        }
    }

    @Override
    public void varsMentioned(Collection<Var> acc) {
        if (this instanceof Q_Var) {
            Q_Var v = (Q_Var)this;
            acc.add(Var.alloc(v.getName()));
            return;
        }
        for (int i = 0; i < this.argCount(); ++i) {
            Expression e2 = this.getArg(i);
            if (e2 == null) continue;
            ExprNodeRDQL ex = (ExprNodeRDQL)e2;
            ex.varsMentioned(acc);
        }
    }

    @Override
    public Valuator prepare(VariableIndexes vi) {
        if (this.children != null) {
            for (int i = 0; i < this.children.length; ++i) {
                RDQL_Node n = this.children[i];
                if (!(n instanceof Expression)) continue;
                ((Expression)((Object)n)).prepare(vi);
            }
        }
        return this;
    }

    @Override
    public Object evalObject(IndexValues iv) {
        return this.evalNode(null, iv);
    }

    @Override
    public boolean evalBool(IndexValues iv) {
        return this.evalBool(null, iv);
    }

    protected boolean evalBool(Query q, IndexValues iv) {
        RDQL_NodeValue v = this.evalNode(q, iv);
        return v == null ? false : v.getBoolean();
    }

    public RDQL_NodeValue evalNode(Query q, IndexValues env) {
        try {
            return this.evalRDQL(q, env);
        }
        catch (RDQLEvalFailureException e2) {
            return null;
        }
        catch (Exception e3) {
            Log.warn(this, "RDQL : general exception!", (Throwable)e3);
            return null;
        }
    }

    @Override
    public boolean isVariable() {
        return false;
    }

    @Override
    public String getName() {
        return null;
    }

    @Override
    public boolean isConstant() {
        return false;
    }

    @Override
    public Object getValue() {
        return null;
    }

    @Override
    public boolean isFunction() {
        return false;
    }

    @Override
    public ExprFunction getFunction() {
        return null;
    }

    @Override
    public boolean isApply() {
        return false;
    }

    @Override
    public String getFun() {
        return null;
    }

    @Override
    public int argCount() {
        return 0;
    }

    @Override
    public Expression getArg(int i) {
        return null;
    }

    protected String constructURI(String className) {
        if (className.lastIndexOf(46) > -1) {
            className = className.substring(className.lastIndexOf(46) + 1);
        }
        return exprBaseURI + className;
    }

    public void format(Query query2, IndentedWriter writer) {
        this.format(writer);
    }

    @Override
    public abstract void format(IndentedWriter var1);

    @Override
    public String toString() {
        return this.asInfixString();
    }
}

