/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.lang;

import com.hp.hpl.jena.query.QueryException;
import com.hp.hpl.jena.query.QueryParseException;
import com.hp.hpl.jena.shared.JenaException;
import com.hp.hpl.jena.sparql.lang.UpdateParser;
import com.hp.hpl.jena.sparql.lang.sparql_11.ParseException;
import com.hp.hpl.jena.sparql.lang.sparql_11.SPARQLParser11;
import com.hp.hpl.jena.sparql.lang.sparql_11.TokenMgrError;
import com.hp.hpl.jena.update.UpdateException;
import com.hp.hpl.jena.update.UpdateRequest;
import com.hp.hpl.jena.util.FileUtils;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import org.openjena.atlas.logging.Log;
import org.slf4j.LoggerFactory;

public class ParserSPARQL11Update
extends UpdateParser {
    public UpdateRequest parse(UpdateRequest update2, String queryString) {
        StringReader r = new StringReader(queryString);
        return this._parse(update2, r);
    }

    public UpdateRequest parse(UpdateRequest update2, InputStream in) {
        BufferedReader r = FileUtils.asBufferedUTF8(in);
        return this._parse(update2, r);
    }

    public UpdateRequest parse(UpdateRequest update2, Reader r) {
        if (r instanceof FileReader) {
            LoggerFactory.getLogger(this.getClass()).warn("FileReader passed to ParserSPARQL11Update.parse - use a FileInputStream");
        }
        return this._parse(update2, r);
    }

    private UpdateRequest _parse(UpdateRequest update2, Reader r) {
        SPARQLParser11 parser = null;
        try {
            parser = new SPARQLParser11(r);
            parser.setUpdateRequest(update2);
            parser.UpdateUnit();
            return update2;
        }
        catch (ParseException ex) {
            throw new QueryParseException(ex.getMessage(), ex.currentToken.beginLine, ex.currentToken.beginColumn);
        }
        catch (TokenMgrError tErr) {
            int col = parser.token.endColumn;
            int line = parser.token.endLine;
            throw new QueryParseException(tErr.getMessage(), line, col);
        }
        catch (UpdateException ex) {
            throw ex;
        }
        catch (JenaException ex) {
            throw new QueryException(ex.getMessage(), ex);
        }
        catch (Error err) {
            throw new QueryParseException(err.getMessage(), (Throwable)err, -1, -1);
        }
        catch (Throwable th) {
            Log.fatal(this, "Unexpected throwable: ", th);
            throw new QueryException(th.getMessage(), th);
        }
    }
}

