/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.graph;

import com.hp.hpl.jena.graph.Capabilities;
import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.graph.TripleMatch;
import com.hp.hpl.jena.graph.impl.AllCapabilities;
import com.hp.hpl.jena.graph.impl.GraphBase;
import com.hp.hpl.jena.sparql.algebra.op.OpBGP;
import com.hp.hpl.jena.sparql.core.BasicPattern;
import com.hp.hpl.jena.sparql.core.DatasetGraph;
import com.hp.hpl.jena.sparql.core.DatasetGraphFactory;
import com.hp.hpl.jena.sparql.core.Var;
import com.hp.hpl.jena.sparql.engine.Plan;
import com.hp.hpl.jena.sparql.engine.QueryEngineFactory;
import com.hp.hpl.jena.sparql.engine.QueryIterator;
import com.hp.hpl.jena.sparql.engine.binding.Binding;
import com.hp.hpl.jena.sparql.engine.binding.BindingRoot;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import com.hp.hpl.jena.util.iterator.WrappedIterator;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GraphSPARQL
extends GraphBase
implements Graph {
    private static Logger log = LoggerFactory.getLogger(GraphSPARQL.class);
    private DatasetGraph dataset;
    private QueryEngineFactory factory;

    public GraphSPARQL(DatasetGraph dataset, QueryEngineFactory factory) {
        this.dataset = dataset;
        this.factory = factory;
    }

    public GraphSPARQL(DatasetGraph dataset, String uri) {
        this(dataset, Node.createURI(uri));
    }

    public GraphSPARQL(DatasetGraph dataset, Node gn) {
        this.dataset = this.toDSG(dataset, gn);
        this.factory = null;
    }

    public GraphSPARQL(Graph graph) {
        this(graph, null);
    }

    public GraphSPARQL(Graph graph, QueryEngineFactory factory) {
        this.dataset = DatasetGraphFactory.create(graph);
        this.factory = factory;
    }

    private DatasetGraph toDSG(DatasetGraph dataset, Node graphNode) {
        Graph graph = graphNode == null ? dataset.getDefaultGraph() : dataset.getGraph(graphNode);
        DatasetGraph dsGraph = DatasetGraphFactory.create(graph);
        return dsGraph;
    }

    @Override
    public Capabilities getCapabilities() {
        if (this.capabilities == null) {
            this.capabilities = new AllCapabilities(){

                public boolean handlesLiteralTyping() {
                    return false;
                }
            };
        }
        return this.capabilities;
    }

    public DatasetGraph getDataset() {
        return this.dataset;
    }

    @Override
    protected ExtendedIterator<Triple> graphBaseFind(TripleMatch m) {
        Node s = m.getMatchSubject();
        Var sVar = null;
        if (s == null) {
            sVar = Var.alloc("s");
            s = sVar;
        }
        Node p = m.getMatchPredicate();
        Var pVar = null;
        if (p == null) {
            pVar = Var.alloc("p");
            p = pVar;
        }
        Node o = m.getMatchObject();
        Var oVar = null;
        if (o == null) {
            oVar = Var.alloc("o");
            o = oVar;
        }
        Triple triple = new Triple(s, p, o);
        BasicPattern pattern = new BasicPattern();
        pattern.add(triple);
        OpBGP op = new OpBGP(pattern);
        Plan plan = this.factory.create(op, this.getDataset(), BindingRoot.create(), null);
        QueryIterator qIter = plan.iterator();
        ArrayList<Triple> triples = new ArrayList<Triple>();
        while (qIter.hasNext()) {
            Binding b = qIter.nextBinding();
            Node sResult = s;
            Node pResult = p;
            Node oResult = o;
            if (sVar != null) {
                sResult = b.get(sVar);
            }
            if (pVar != null) {
                pResult = b.get(pVar);
            }
            if (oVar != null) {
                oResult = b.get(oVar);
            }
            Triple resultTriple = new Triple(sResult, pResult, oResult);
            if (log.isDebugEnabled()) {
                log.debug("  " + resultTriple);
            }
            triples.add(resultTriple);
        }
        qIter.close();
        return WrappedIterator.createNoRemove(triples.iterator());
    }
}

