/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.expr;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.sparql.ARQInternalErrorException;
import com.hp.hpl.jena.sparql.core.Var;
import com.hp.hpl.jena.sparql.engine.binding.Binding;
import com.hp.hpl.jena.sparql.expr.Expr;
import com.hp.hpl.jena.sparql.expr.ExprNode;
import com.hp.hpl.jena.sparql.expr.ExprTransform;
import com.hp.hpl.jena.sparql.expr.ExprVar;
import com.hp.hpl.jena.sparql.expr.ExprVisitor;
import com.hp.hpl.jena.sparql.expr.NodeValue;
import com.hp.hpl.jena.sparql.expr.aggregate.Aggregator;
import com.hp.hpl.jena.sparql.function.FunctionEnv;
import com.hp.hpl.jena.sparql.graph.NodeTransform;
import com.hp.hpl.jena.sparql.util.Utils;
import org.openjena.atlas.logging.Log;

public class ExprAggregator
extends ExprNode {
    protected Aggregator aggregator;
    protected Var var;
    protected ExprVar exprVar = null;

    public ExprAggregator(Var v, Aggregator agg) {
        this._setVar(v);
        this.aggregator = agg;
    }

    public Var getVar() {
        return this.var;
    }

    public void setVar(Var v) {
        if (this.var != null) {
            throw new ARQInternalErrorException(Utils.className(this) + ": Attempt to set variable to " + v + " when already set as " + this.var);
        }
        if (v == null) {
            throw new ARQInternalErrorException(Utils.className(this) + ": Attempt to set variable to null");
        }
        this._setVar(v);
    }

    private void _setVar(Var v) {
        this.var = v;
        this.exprVar = new ExprVar(this.var);
    }

    public Aggregator getAggregator() {
        return this.aggregator;
    }

    public int hashCode() {
        int x = ((Object)this.aggregator).hashCode();
        if (this.var != null) {
            x ^= this.var.hashCode();
        }
        return x;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ExprAggregator)) {
            return false;
        }
        ExprAggregator agg = (ExprAggregator)other;
        return ((Object)this.aggregator).equals(agg.aggregator);
    }

    public ExprVar getExprVar() {
        throw new ARQInternalErrorException();
    }

    public Var asVar() {
        throw new ARQInternalErrorException();
    }

    public ExprVar getAggVar() {
        return this.exprVar;
    }

    public String asSparqlExpr() {
        return this.aggregator.toString();
    }

    public ExprAggregator copySubstitute(Binding binding, boolean foldConstants) {
        Var v = this.var;
        Aggregator agg = this.aggregator;
        return new ExprAggregator(v, agg);
    }

    public ExprAggregator applyNodeTransform(NodeTransform transform) {
        Node node = transform.convert(this.var);
        if (!Var.isVar(node)) {
            Log.warn(this, "Attempt to convert an aggregation variable to a non-variable: ignored");
            node = this.var;
        }
        Var v = (Var)node;
        Aggregator agg = this.aggregator.copyTransform(transform);
        return new ExprAggregator(Var.alloc(node), agg);
    }

    public String toString() {
        return "(AGG " + (this.var == null ? "<>" : "?" + this.var.getVarName()) + " " + this.aggregator.toString() + ")";
    }

    public Expr copy(Var v) {
        return new ExprAggregator(v, this.aggregator.copy(this.aggregator.getExpr()));
    }

    public NodeValue eval(Binding binding, FunctionEnv env) {
        return ExprVar.eval(this.var, binding, env);
    }

    public Expr apply(ExprTransform transform) {
        return transform.transform(this);
    }

    public void visit(ExprVisitor visitor) {
        visitor.visit(this);
    }
}

