/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.core;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import org.openjena.atlas.lib.Lib;

public class Quad {
    public static final Node defaultGraphNodeGenerated = Node.createURI("urn:x-arq:DefaultGraphNode");
    public static final Node defaultGraphIRI = Node.createURI("urn:x-arq:DefaultGraph");
    public static final Node tripleInQuad = null;
    public static final Node unionGraph = Node.createURI("urn:x-arq:UnionGraph");
    private final Node graph;
    private final Node subject;
    private final Node predicate;
    private final Node object;
    private Triple triple = null;

    public Quad(Node graph, Triple triple) {
        this(graph, triple.getSubject(), triple.getPredicate(), triple.getObject());
    }

    public Quad(Node g, Node s, Node p, Node o) {
        if (s == null) {
            throw new UnsupportedOperationException("Quad: subject cannot be null");
        }
        if (p == null) {
            throw new UnsupportedOperationException("Quad: predicate cannot be null");
        }
        if (o == null) {
            throw new UnsupportedOperationException("Quad: object cannot be null");
        }
        this.graph = g;
        this.subject = s;
        this.predicate = p;
        this.object = o;
    }

    public final Node getGraph() {
        return this.graph;
    }

    public final Node getSubject() {
        return this.subject;
    }

    public final Node getPredicate() {
        return this.predicate;
    }

    public final Node getObject() {
        return this.object;
    }

    public Triple asTriple() {
        if (this.triple == null) {
            this.triple = new Triple(this.subject, this.predicate, this.object);
        }
        return this.triple;
    }

    public boolean isConcrete() {
        return this.subject.isConcrete() && this.predicate.isConcrete() && this.object.isConcrete() && this.graph.isConcrete();
    }

    public static boolean isQuadDefaultGraphGenerated(Node node) {
        return node.equals(defaultGraphNodeGenerated);
    }

    public static boolean isDefaultGraph(Node node) {
        return node.equals(defaultGraphNodeGenerated) || node.equals(defaultGraphIRI);
    }

    public boolean isDefaultGraphGenerated() {
        return Quad.isQuadDefaultGraphGenerated(this.getGraph());
    }

    public boolean isDefaultGraph() {
        return Quad.isDefaultGraph(this.getGraph());
    }

    public static boolean isQuadUnionGraph(Node node) {
        return node.equals(unionGraph);
    }

    public boolean isTriple() {
        return Lib.equal(this.graph, tripleInQuad);
    }

    public boolean isDefaultGraphIRI() {
        return this.graph.equals(defaultGraphIRI);
    }

    public boolean isUnionGraph() {
        return Quad.isQuadUnionGraph(this.graph);
    }

    public int hashCode() {
        int x = this.subject.hashCode() >> 1 ^ this.predicate.hashCode() ^ this.object.hashCode() << 1;
        x = this.graph != null ? (x ^= this.graph.hashCode() >> 2) : ++x;
        return x;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Quad)) {
            return false;
        }
        Quad quad = (Quad)other;
        if (!Lib.equal(this.graph, quad.graph)) {
            return false;
        }
        if (!this.subject.equals(quad.subject)) {
            return false;
        }
        if (!this.predicate.equals(quad.predicate)) {
            return false;
        }
        return this.object.equals(quad.object);
    }

    public boolean matches(Node g, Node s, Node p, Node o) {
        return Quad.matches(this.getGraph(), g) && Quad.matches(this.getSubject(), s) && Quad.matches(this.getPredicate(), p) && Quad.matches(this.getObject(), o);
    }

    private static boolean matches(Node thisNode, Node otherNode) {
        return otherNode.matches(thisNode);
    }

    public String toString() {
        String str2 = this.graph == null ? "_" : this.graph.toString();
        return "[" + str2 + " " + this.subject.toString() + " " + this.predicate.toString() + " " + this.object.toString() + "]";
    }
}

