/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.algebra.op;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.sparql.algebra.Op;
import com.hp.hpl.jena.sparql.algebra.OpVisitor;
import com.hp.hpl.jena.sparql.algebra.Transform;
import com.hp.hpl.jena.sparql.algebra.op.Op1;
import com.hp.hpl.jena.sparql.syntax.ElementService;
import com.hp.hpl.jena.sparql.util.NodeIsomorphismMap;

public class OpService
extends Op1 {
    Node serviceNode = null;
    private ElementService serviceElement = null;

    public OpService(Node serviceNode, Op subOp) {
        this(serviceNode, subOp, null);
    }

    public OpService(Node serviceNode, Op subOp, ElementService elt) {
        super(subOp);
        this.serviceNode = serviceNode;
        this.serviceElement = elt;
    }

    public Op apply(Transform transform, Op subOp) {
        return transform.transform(this, subOp);
    }

    public Op copy(Op newOp) {
        return new OpService(this.serviceNode, newOp);
    }

    public String getName() {
        return "service";
    }

    public void visit(OpVisitor opVisitor) {
        opVisitor.visit(this);
    }

    public Node getService() {
        return this.serviceNode;
    }

    public ElementService getServiceElement() {
        return this.serviceElement;
    }

    public int hashCode() {
        return this.serviceNode.hashCode() ^ this.getSubOp().hashCode();
    }

    public boolean equalTo(Op other, NodeIsomorphismMap labelMap) {
        if (!(other instanceof OpService)) {
            return false;
        }
        OpService opService = (OpService)other;
        if (!this.serviceNode.equals(opService.serviceNode)) {
            return false;
        }
        return this.getSubOp().equalTo(opService.getSubOp(), labelMap);
    }
}

